/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.BaseSaveAction;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;

public class SaveAction
extends BaseSaveAction {
    public SaveAction(IWorkbenchWindow window) {
        super(WorkbenchMessages.SaveAction_text, window);
        this.setText(WorkbenchMessages.SaveAction_text);
        this.setToolTipText(WorkbenchMessages.SaveAction_toolTip);
        this.setId("save");
        window.getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.save_action_context");
        this.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_ETOOL_SAVE_EDIT"));
        this.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_ETOOL_SAVE_EDIT_DISABLED"));
        this.setActionDefinitionId("org.eclipse.ui.file.save");
    }

    public void run() {
        if (this.getWorkbenchWindow() == null) {
            return;
        }
        ISaveablePart saveView = this.getSaveableView();
        if (saveView != null) {
            ((WorkbenchPage)this.getActivePart().getSite().getPage()).savePart(saveView, this.getActivePart(), false);
            return;
        }
        IEditorPart part = this.getActiveEditor();
        if (part != null) {
            IWorkbenchPage page = part.getSite().getPage();
            page.saveEditor(part, false);
        }
    }

    protected void updateState() {
        ISaveablePart saveView = this.getSaveableView();
        if (saveView != null) {
            this.setEnabled(saveView.isDirty());
            return;
        }
        IEditorPart editor = this.getActiveEditor();
        this.setEnabled(editor != null && editor.isDirty());
    }
}

