/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.AliasMapper;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public class BundleNativeCode {
    private Attribute nativepaths;
    private Attribute processor;
    private Attribute osname;
    private Attribute language;
    private Attribute osversion;
    private String filterString;
    private AbstractBundle bundle;
    private static AliasMapper aliasMapper = Framework.aliasMapper;

    protected BundleNativeCode(ManifestElement element, AbstractBundle bundle) {
        this.bundle = bundle;
        String[] nativePaths = element.getValueComponents();
        int i = 0;
        while (i < nativePaths.length) {
            this.addPath(nativePaths[i]);
            ++i;
        }
        this.setAttribute(element, "osname");
        this.setAttribute(element, "processor");
        this.setAttribute(element, "osversion");
        this.setAttribute(element, "language");
        this.setAttribute(element, "selection-filter");
    }

    private void setAttribute(ManifestElement element, String attribute) {
        String[] attrValues = element.getAttributes(attribute);
        if (attrValues != null) {
            int i = 0;
            while (i < attrValues.length) {
                this.addAttribute(attribute, attrValues[i]);
                ++i;
            }
        }
    }

    public String[] getPaths() {
        if (this.nativepaths == null) {
            return null;
        }
        String[] paths = new String[this.nativepaths.size()];
        this.nativepaths.toArray(paths);
        return paths;
    }

    protected void addPath(String nativepath) {
        if (this.nativepaths == null) {
            this.nativepaths = new Attribute();
        }
        this.nativepaths.addElement(nativepath);
    }

    protected synchronized void addAttribute(String key, String value) {
        if (key.equals("processor")) {
            if (this.processor == null) {
                this.processor = new Attribute();
            }
            this.processor.addElement(aliasMapper.aliasProcessor(value));
            return;
        }
        if (key.equals("osname")) {
            if (this.osname == null) {
                this.osname = new Attribute();
            }
            this.osname.addElement(aliasMapper.aliasOSName(value));
            return;
        }
        if (key.equals("osversion")) {
            if (this.osversion == null) {
                this.osversion = new Attribute();
            }
            this.osversion.addElement(new VersionRange(value));
            return;
        }
        if (key.equals("selection-filter")) {
            if (this.filterString == null) {
                this.filterString = value;
            }
            return;
        }
        if (key.equals("language")) {
            if (this.language == null) {
                this.language = new Attribute();
            }
            this.language.addElement(value.toLowerCase());
            return;
        }
    }

    public String toString() {
        int size = this.nativepaths.size();
        StringBuffer sb = new StringBuffer(50 * size);
        int i = 0;
        while (i < size) {
            if (i > 0) {
                sb.append(';');
            }
            sb.append(this.nativepaths.elementAt(i).toString());
            ++i;
        }
        if (this.processor != null) {
            size = this.processor.size();
            i = 0;
            while (i < size) {
                sb.append(';');
                sb.append("processor");
                sb.append('=');
                sb.append(this.processor.elementAt(i).toString());
                ++i;
            }
        }
        if (this.osname != null) {
            size = this.osname.size();
            i = 0;
            while (i < size) {
                sb.append(';');
                sb.append("osname");
                sb.append('=');
                sb.append(this.osname.elementAt(i).toString());
                ++i;
            }
        }
        if (this.osversion != null) {
            size = this.osversion.size();
            i = 0;
            while (i < size) {
                sb.append(';');
                sb.append("osversion");
                sb.append('=');
                sb.append(this.osversion.elementAt(i).toString());
                ++i;
            }
        }
        if (this.language != null) {
            size = this.language.size();
            i = 0;
            while (i < size) {
                sb.append(';');
                sb.append("language");
                sb.append('=');
                sb.append(this.language.elementAt(i).toString());
                ++i;
            }
        }
        return sb.toString();
    }

    public int matchProcessorOSNameFilter(String processor, String osname) {
        if (this.processor == null || this.osname == null) {
            return 0;
        }
        String otherProcessor = aliasMapper.aliasProcessor(processor);
        String otherOSName = (String)aliasMapper.aliasOSName(osname);
        if (this.processor.equals(otherProcessor) && this.osname.equals(otherOSName) && this.matchFilter()) {
            return 1;
        }
        return 0;
    }

    public Version matchOSVersion(Version version) {
        if (this.osversion == null) {
            return Version.emptyVersion;
        }
        Version result = null;
        int size = this.osversion.size();
        int i = 0;
        while (i < size) {
            VersionRange range = (VersionRange)this.osversion.elementAt(i);
            if (range.isIncluded(version) && (result == null || range.getMinimum().compareTo(result) > 0)) {
                result = range.getMinimum();
            }
            ++i;
        }
        return result;
    }

    public int matchLanguage(String language) {
        if (this.language == null) {
            return 1;
        }
        if (this.language.equals(language.toLowerCase())) {
            return 2;
        }
        return 0;
    }

    public boolean matchFilter() {
        FilterImpl filter;
        if (this.filterString == null) {
            return true;
        }
        try {
            filter = new FilterImpl(this.filterString);
        }
        catch (InvalidSyntaxException e) {
            BundleException be = new BundleException(Msg.BUNDLE_NATIVECODE_INVALID_FILTER, e);
            this.bundle.framework.publishFrameworkEvent(2, this.bundle, be);
            return false;
        }
        return filter.match(System.getProperties());
    }

    static class Attribute
    extends Vector {
        private static final long serialVersionUID = 3257005440914174512L;

        Attribute() {
            super(10, 10);
        }

        public synchronized boolean equals(Object obj) {
            int i = 0;
            while (i < this.elementCount) {
                Object data = this.elementData[i];
                if (data instanceof String) {
                    if (this.elementData[i].equals(obj)) {
                        return true;
                    }
                } else {
                    Enumeration e = ((Vector)data).elements();
                    while (e.hasMoreElements()) {
                        if (!((String)e.nextElement()).equals(obj)) continue;
                        return true;
                    }
                }
                ++i;
            }
            return false;
        }

        public synchronized void addElement(Object obj) {
            if (!this.contains(obj)) {
                super.addElement(obj);
            }
        }
    }
}

