/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.composite.tree;

import com.clustercontrol.performance.composite.tree.CollectorTreeContentProvider;
import com.clustercontrol.performance.composite.tree.CollectorTreeLabelProvider;
import com.clustercontrol.performance.util.CollectorItemCodeFactory;
import com.clustercontrol.performanceMGR.bean.CollectorItemInfo;
import com.clustercontrol.performanceMGR.bean.DeviceData;
import com.clustercontrol.performanceMGR.util.code.CollectorItemCategoryInfo;
import com.clustercontrol.performanceMGR.util.code.CollectorItemCodeInfo;
import com.clustercontrol.performanceMGR.util.code.CollectorItemTreeItem;
import com.clustercontrol.performanceMGR.util.code.ICollectorItemInfo;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectorTreeComposite
extends Composite {
    private TreeViewer treeViewer = null;
    private CollectorItemTreeItem[] treeItem;
    private ArrayList<CollectorItemInfo> itemList = new ArrayList();
    private String m_collectorID = null;
    private int collectorItemID = 0;
    Listener subItemCheckListener;
    Listener ItemCheckDisableListener;

    public CollectorTreeComposite(Composite parent, int style, String facilityId, String collectorId) {
        super(parent, style);
        this.setData("FacilityId", facilityId);
        this.m_collectorID = collectorId;
        this.createContents();
    }

    private TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    private Tree getTree() {
        return this.treeViewer.getTree();
    }

    protected void createContents() {
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        Tree tree = new Tree((Composite)this, 2084);
        GridData layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        tree.setLayoutData((Object)layoutData);
        this.treeViewer = new TreeViewer(tree);
        this.treeViewer.setContentProvider((IContentProvider)new CollectorTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new CollectorTreeLabelProvider());
        this.setListener(true);
        this.update();
    }

    private void treeToList(TreeItem[] treeItems) {
        int i = 0;
        while (i < treeItems.length) {
            if (treeItems[i] != null) {
                TreeItem[] children;
                CollectorItemTreeItem treeItem;
                ICollectorItemInfo obj;
                if (treeItems[i].getChecked() && !((obj = (treeItem = (CollectorItemTreeItem)treeItems[i].getData()).getData()) instanceof CollectorItemCategoryInfo) && obj instanceof CollectorItemCodeInfo) {
                    CollectorItemCodeInfo codeInfo = (CollectorItemCodeInfo)obj;
                    int deviceIndex = 0;
                    String deviceName = null;
                    if (treeItem.getDeviceData() != null) {
                        deviceIndex = treeItem.getDeviceData().getDeviceIndex();
                        deviceName = treeItem.getDeviceData().getDeviceName();
                    }
                    CollectorItemInfo itemInfo = new CollectorItemInfo(this.m_collectorID, this.collectorItemID, codeInfo.getCode(), deviceIndex, deviceName, false);
                    this.itemList.add(itemInfo);
                    ++this.collectorItemID;
                }
                if ((children = treeItems[i].getItems()) != null) {
                    this.treeToList(children);
                }
            }
            ++i;
        }
    }

    private void setChecked(TreeItem treeItem, boolean checked) {
        treeItem.setExpanded(true);
        treeItem.setChecked(checked);
        TreeItem[] children = treeItem.getItems();
        int i = 0;
        while (i < children.length) {
            if (children[i] != null) {
                this.setChecked(children[i], checked);
            }
            ++i;
        }
    }

    private boolean setCheckedTreeItem(TreeItem[] treeItems) {
        boolean checked = false;
        int i = 0;
        while (i < treeItems.length) {
            if (treeItems[i] != null) {
                CollectorItemTreeItem collectorTreeInfo = (CollectorItemTreeItem)treeItems[i].getData();
                ICollectorItemInfo obj = collectorTreeInfo.getData();
                if (obj instanceof CollectorItemCategoryInfo) {
                    treeItems[i].setChecked(false);
                } else if (obj instanceof CollectorItemCodeInfo) {
                    for (CollectorItemInfo itemInfo : this.itemList) {
                        if (!((CollectorItemCodeInfo)obj).getCode().equals(itemInfo.getCollectorItemCode())) continue;
                        DeviceData deviceData = collectorTreeInfo.getDeviceData();
                        if (deviceData == null) {
                            treeItems[i].setChecked(true);
                            checked = true;
                            continue;
                        }
                        if (!deviceData.getDeviceName().equals(itemInfo.getDeviceName())) continue;
                        treeItems[i].setChecked(true);
                        checked = true;
                    }
                }
                TreeItem[] children = treeItems[i].getItems();
                if (children != null) {
                    treeItems[i].setExpanded(true);
                    if (this.setCheckedTreeItem(children)) {
                        checked = true;
                    } else {
                        treeItems[i].setExpanded(false);
                    }
                }
            }
            ++i;
        }
        return checked;
    }

    public void update() {
        String facilityId = (String)this.getData("FacilityId");
        ArrayList<CollectorItemInfo> buffItemList = new ArrayList<CollectorItemInfo>();
        Iterator<CollectorItemInfo> itr = this.itemList.iterator();
        while (itr.hasNext()) {
            buffItemList.add(itr.next());
        }
        this.treeItem = CollectorItemCodeFactory.getCollectorTree(facilityId, this.m_collectorID);
        this.treeViewer.setInput((Object)this.treeItem);
        this.setVisible(false);
        this.treeViewer.expandAll();
        this.treeViewer.collapseAll();
        this.setVisible(true);
        if (buffItemList.size() != 0) {
            this.setItemList(buffItemList);
            this.collectorItemID = 0;
            this.itemList.clear();
            this.treeToList(this.getTree().getItems());
        }
    }

    public ArrayList getItemList() {
        return this.itemList;
    }

    public void setItemList(ArrayList<CollectorItemInfo> itemList) {
        this.itemList = itemList;
        this.setCheckedTreeItem(this.getTree().getItems());
    }

    public void setEnabled(boolean enabled) {
        this.setListener(enabled);
    }

    private void setListener(boolean enabled) {
        if (this.subItemCheckListener != null) {
            this.treeViewer.getTree().removeListener(13, this.subItemCheckListener);
            this.subItemCheckListener = null;
        }
        if (this.ItemCheckDisableListener != null) {
            this.treeViewer.getTree().removeListener(13, this.subItemCheckListener);
            this.ItemCheckDisableListener = null;
        }
        if (enabled) {
            this.subItemCheckListener = new Listener(){

                public void handleEvent(Event event) {
                    if (event.detail == 32) {
                        if (((TreeItem)event.item).getChecked()) {
                            CollectorTreeComposite.this.setChecked((TreeItem)event.item, true);
                        }
                        CollectorTreeComposite.this.collectorItemID = 0;
                        CollectorTreeComposite.this.itemList.clear();
                        CollectorTreeComposite.this.treeToList(CollectorTreeComposite.this.getTree().getItems());
                    }
                }
            };
            this.treeViewer.getTree().addListener(13, this.subItemCheckListener);
        } else {
            this.ItemCheckDisableListener = new Listener(){

                public void handleEvent(Event event) {
                    if (event.detail == 32) {
                        if (((TreeItem)event.item).getChecked()) {
                            ((TreeItem)event.item).setChecked(false);
                        } else {
                            ((TreeItem)event.item).setChecked(true);
                        }
                    }
                }
            };
            this.treeViewer.getTree().addListener(13, this.ItemCheckDisableListener);
        }
    }
}

