/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.logtransfer.composite;

import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.logtransfer.action.GetLogTransferFileListTableDefine;
import com.clustercontrol.logtransfer.bean.LogTransferFileInfo;
import com.clustercontrol.logtransfer.bean.LogTransferInfo;
import com.clustercontrol.logtransfer.composite.action.LogTransferFileSelectionChangedListener;
import com.clustercontrol.logtransfer.dialog.LogTransferFileDialog;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class LogTransferFileListComposite
extends Composite {
    protected CommonTableViewer m_tableViewer = null;
    protected Button m_buttonAdd = null;
    protected Button m_buttonModify = null;
    protected Button m_buttonDelete = null;
    protected Shell m_shell = null;
    protected ArrayList m_selectItem = null;

    public LogTransferFileListComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
        this.m_shell = this.getShell();
    }

    private void initialize() {
        Label label = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 15;
        this.setLayout((Layout)layout);
        label = new Label((Composite)this, 0);
        label.setText(String.valueOf(Messages.getString("logtransfer.file.list")) + " : ");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        Table table = new Table((Composite)this, 68356);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.minimumHeight = 200;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 9;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.m_buttonAdd = new Button((Composite)this, 0);
        this.m_buttonAdd.setText(Messages.getString("add"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_buttonAdd.setLayoutData((Object)gridData);
        this.m_buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogTransferFileDialog dialog = new LogTransferFileDialog(LogTransferFileListComposite.this.m_shell);
                if (dialog.open() == 0) {
                    ArrayList info = dialog.getInputData();
                    ArrayList<ArrayList> list = (ArrayList<ArrayList>)LogTransferFileListComposite.this.m_tableViewer.getInput();
                    if (list == null) {
                        list = new ArrayList<ArrayList>();
                    }
                    list.add(info);
                    LogTransferFileListComposite.this.m_tableViewer.setInput(list);
                }
            }
        });
        this.m_buttonModify = new Button((Composite)this, 0);
        this.m_buttonModify.setText(Messages.getString("modify"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_buttonModify.setLayoutData((Object)gridData);
        this.m_buttonModify.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogTransferFileDialog dialog = new LogTransferFileDialog(LogTransferFileListComposite.this.m_shell);
                if (LogTransferFileListComposite.this.m_selectItem instanceof ArrayList) {
                    dialog.setInputData(LogTransferFileListComposite.this.m_selectItem);
                    if (dialog.open() == 0) {
                        ArrayList info = dialog.getInputData();
                        ArrayList list = (ArrayList)LogTransferFileListComposite.this.m_tableViewer.getInput();
                        list.remove(LogTransferFileListComposite.this.m_selectItem);
                        list.add(info);
                        LogTransferFileListComposite.this.m_selectItem = null;
                        LogTransferFileListComposite.this.m_tableViewer.setInput(list);
                    }
                } else {
                    MessageDialog.openWarning(null, (String)Messages.getString("warning"), (String)Messages.getString("message.logtransfer.11"));
                }
            }
        });
        this.m_buttonDelete = new Button((Composite)this, 0);
        this.m_buttonDelete.setText(Messages.getString("delete"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_buttonDelete.setLayoutData((Object)gridData);
        this.m_buttonDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (LogTransferFileListComposite.this.m_selectItem instanceof ArrayList) {
                    ArrayList list = (ArrayList)LogTransferFileListComposite.this.m_tableViewer.getInput();
                    String filePath = (String)LogTransferFileListComposite.this.m_selectItem.get(0);
                    Object[] args = new String[]{filePath};
                    if (MessageDialog.openConfirm(null, (String)Messages.getString("confirmed"), (String)Messages.getString("message.logtransfer.14", args))) {
                        list.remove(LogTransferFileListComposite.this.m_selectItem);
                        LogTransferFileListComposite.this.m_selectItem = null;
                        LogTransferFileListComposite.this.m_tableViewer.setInput(list);
                    }
                } else {
                    MessageDialog.openWarning(null, (String)Messages.getString("warning"), (String)Messages.getString("message.logtransfer.11"));
                }
            }
        });
        this.m_tableViewer = new CommonTableViewer(table);
        this.m_tableViewer.createTableColumn(GetLogTransferFileListTableDefine.get(), 0, 1);
        this.m_tableViewer.addSelectionChangedListener(new LogTransferFileSelectionChangedListener(this));
    }

    public void setInputData(LogTransferInfo info) {
        if (info != null) {
            ArrayList tableData = new ArrayList();
            ArrayList<LogTransferFileInfo> fileList = info.getFileInfo();
            int index = 0;
            while (index < fileList.size()) {
                LogTransferFileInfo fileInfo = fileList.get(index);
                ArrayList<Object> tableLineData = new ArrayList<Object>();
                tableLineData.add(fileInfo.getFilePath());
                tableLineData.add(fileInfo.getRunInterval());
                tableLineData.add(YesNoConstant.typeToBoolean(fileInfo.getExistenceFlg()));
                tableLineData.add(fileInfo.getValid());
                tableData.add(tableLineData);
                ++index;
            }
            this.m_tableViewer.setInput(tableData);
        }
    }

    public ValidateResult createInputData(LogTransferInfo info) {
        ArrayList<LogTransferFileInfo> list;
        ArrayList tableData = (ArrayList)this.m_tableViewer.getInput();
        if (tableData != null && tableData.size() > 0) {
            list = new ArrayList<LogTransferFileInfo>();
            ArrayList<String> filePathList = new ArrayList<String>();
            String transferId = info.getTransferId();
            int index = 0;
            while (index < tableData.size()) {
                ArrayList tableLineData = (ArrayList)tableData.get(index);
                String filePath = (String)tableLineData.get(0);
                if (filePathList.contains(filePath)) {
                    Object[] args = new String[]{filePath};
                    return this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.logtransfer.15", args));
                }
                filePathList.add(filePath);
                LogTransferFileInfo fileInfo = new LogTransferFileInfo();
                fileInfo.setTransferId(transferId);
                fileInfo.setFilePath(filePath);
                fileInfo.setRunInterval((Integer)tableLineData.get(1));
                fileInfo.setExistenceFlg(YesNoConstant.booleanToType((Boolean)tableLineData.get(2)));
                fileInfo.setValid((Integer)tableLineData.get(3));
                list.add(fileInfo);
                ++index;
            }
        } else {
            return this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.logtransfer.11"));
        }
        info.setFileInfo(list);
        return null;
    }

    protected ValidateResult setValidateResult(String id, String message) {
        ValidateResult validateResult = new ValidateResult();
        validateResult.setValid(false);
        validateResult.setID(id);
        validateResult.setMessage(message);
        return validateResult;
    }

    public ArrayList getSelectItem() {
        return this.m_selectItem;
    }

    public void setSelectItem(ArrayList selectItem) {
        this.m_selectItem = selectItem;
    }
}

