/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.font.TextAttribute;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.util.JRTextAttribute;

public class JRFontUtil {
    public static Map getNonPdfAttributes(JRFont font) {
        HashMap nonPdfAttributes = new HashMap();
        JRFontUtil.setNonPdfAttributes(nonPdfAttributes, font);
        return nonPdfAttributes;
    }

    private static Map setNonPdfAttributes(Map attributes, JRFont font) {
        attributes.put(TextAttribute.FAMILY, font.getFontName());
        attributes.put(TextAttribute.SIZE, new Float(font.getFontSize()));
        if (font.isBold()) {
            attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (font.isItalic()) {
            attributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        if (font.isUnderline()) {
            attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (font.isStrikeThrough()) {
            attributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        return attributes;
    }

    public static Map setAttributes(Map attributes, JRFont font) {
        attributes = JRFontUtil.setNonPdfAttributes(attributes, font);
        attributes.put(JRTextAttribute.PDF_FONT_NAME, font.getPdfFontName());
        attributes.put(JRTextAttribute.PDF_ENCODING, font.getPdfEncoding());
        if (font.isPdfEmbedded()) {
            attributes.put(JRTextAttribute.IS_PDF_EMBEDDED, Boolean.TRUE);
        }
        return attributes;
    }
}

