/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.sql.util;

import com.clustercontrol.sql.util.ControlSqlInfo;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AccessDB {
    protected static Log m_log = LogFactory.getLog(ControlSqlInfo.class);
    protected Connection m_connection = null;
    protected Statement m_statement = null;
    protected String m_jdbcDriver = null;
    protected String m_url = null;
    protected String m_user = null;
    protected String m_password = null;

    public AccessDB(String driver, String url, String user, String password) throws SQLException, ClassNotFoundException {
        this.m_jdbcDriver = driver;
        this.m_url = url;
        this.m_user = user;
        this.m_password = password;
        this.initial();
    }

    private void initial() throws SQLException, ClassNotFoundException {
        try {
            Class.forName(this.m_jdbcDriver);
        }
        catch (ClassNotFoundException e) {
            m_log.error((Object)"initialize(): ", (Throwable)e);
            throw e;
        }
        Properties prop = new Properties();
        prop.put("user", this.m_user);
        prop.put("password", this.m_password);
        try {
            this.m_connection = DriverManager.getConnection(this.m_url, prop);
            this.m_statement = this.m_connection.createStatement(1004, 1007);
        }
        catch (SQLException e) {
            m_log.error((Object)"initialize(): ", (Throwable)e);
            try {
                if (this.m_statement != null) {
                    this.m_statement.close();
                }
            }
            catch (SQLException se) {
                m_log.error((Object)"initialize(): ", (Throwable)se);
            }
            try {
                if (this.m_connection != null) {
                    this.m_connection.close();
                }
            }
            catch (SQLException se) {
                m_log.error((Object)"initialize(): ", (Throwable)se);
            }
            throw e;
        }
    }

    public ResultSet read(String sql) throws SQLException {
        ResultSet result = null;
        try {
            result = this.m_statement.executeQuery(sql);
        }
        catch (SQLException e) {
            m_log.error((Object)"read(): ", (Throwable)e);
            throw e;
        }
        return result;
    }

    public void terminate() {
        try {
            if (this.m_statement != null) {
                this.m_statement.close();
            }
        }
        catch (SQLException e) {
            m_log.error((Object)"terminate(): ", (Throwable)e);
        }
        try {
            if (this.m_connection != null) {
                this.m_connection.close();
            }
        }
        catch (SQLException e) {
            m_log.error((Object)"terminate(): ", (Throwable)e);
        }
    }
}

