package jp.sourceforge.jetspeedjapan.portlet.weblog.om;


import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Collections;
import java.util.List;

import org.apache.commons.lang.ObjectUtils;
import org.apache.torque.TorqueException;
import org.apache.torque.om.BaseObject;
import org.apache.torque.om.ComboKey;
import org.apache.torque.om.DateKey;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.om.StringKey;
import org.apache.torque.om.Persistent;
import org.apache.torque.util.Criteria;
import org.apache.torque.util.Transaction;

   
   
/**
 * This class was autogenerated by Torque on:
 *
 * [Mon Aug 11 00:36:14 JST 2003]
 *
 * You should not use this class directly.  It should not even be
 * extended all references should be to WeblogTrackback
 */
public abstract class BaseWeblogTrackback extends BaseObject
{
    /** The Peer class */
    private static final WeblogTrackbackPeer peer =
        new WeblogTrackbackPeer();

                  
        /**
         * The value for the weblog_trackback_id field
         */
        private int weblog_trackback_id;
              
        /**
         * The value for the weblog_id field
         */
        private int weblog_id;
              
        /**
         * The value for the url field
         */
        private String url;
              
        /**
         * The value for the name field
         */
        private String name;
              
        /**
         * The value for the title field
         */
        private String title;
              
        /**
         * The value for the overview field
         */
        private String overview;
              
        /**
         * The value for the posted_date field
         */
        private Date posted_date;
              
        /**
         * The value for the log field
         */
        private String log;
      
      
        /**
         * Get the WeblogTrackbackId
         *
         * @return int
         */
        public int getWeblogTrackbackId()
        {
            return weblog_trackback_id;
        }

                                            
        /**
         * Set the value of WeblogTrackbackId
         *
         * @param v new value
         */
        public void setWeblogTrackbackId(int v) 
        {
          


         if (this.weblog_trackback_id != v)
        {
             this.weblog_trackback_id = v;
            setModified(true);
        }

                  
                       }


        /**
         * Get the WeblogId
         *
         * @return int
         */
        public int getWeblogId()
        {
            return weblog_id;
        }

                                                      
        /**
         * Set the value of WeblogId
         *
         * @param v new value
         */
        public void setWeblogId(int v) throws TorqueException
        {
          


         if (this.weblog_id != v)
        {
             this.weblog_id = v;
            setModified(true);
        }

                                          
                if (aWeblog != null && !(aWeblog.getWeblogId()==v))
                {
            aWeblog = null;
        }
          
                       }


        /**
         * Get the Url
         *
         * @return String
         */
        public String getUrl()
        {
            return url;
        }

                                            
        /**
         * Set the value of Url
         *
         * @param v new value
         */
        public void setUrl(String v) 
        {
          


         if (!ObjectUtils.equals(this.url, v))
        {
             this.url = v;
            setModified(true);
        }

                  
                       }


        /**
         * Get the Name
         *
         * @return String
         */
        public String getName()
        {
            return name;
        }

                                            
        /**
         * Set the value of Name
         *
         * @param v new value
         */
        public void setName(String v) 
        {
          


         if (!ObjectUtils.equals(this.name, v))
        {
             this.name = v;
            setModified(true);
        }

                  
                       }


        /**
         * Get the Title
         *
         * @return String
         */
        public String getTitle()
        {
            return title;
        }

                                            
        /**
         * Set the value of Title
         *
         * @param v new value
         */
        public void setTitle(String v) 
        {
          


         if (!ObjectUtils.equals(this.title, v))
        {
             this.title = v;
            setModified(true);
        }

                  
                       }


        /**
         * Get the Overview
         *
         * @return String
         */
        public String getOverview()
        {
            return overview;
        }

                                            
        /**
         * Set the value of Overview
         *
         * @param v new value
         */
        public void setOverview(String v) 
        {
          


         if (!ObjectUtils.equals(this.overview, v))
        {
             this.overview = v;
            setModified(true);
        }

                  
                       }


        /**
         * Get the PostedDate
         *
         * @return Date
         */
        public Date getPostedDate()
        {
            return posted_date;
        }

                                            
        /**
         * Set the value of PostedDate
         *
         * @param v new value
         */
        public void setPostedDate(Date v) 
        {
          


         if (!ObjectUtils.equals(this.posted_date, v))
        {
             this.posted_date = v;
            setModified(true);
        }

                  
                       }


        /**
         * Get the Log
         *
         * @return String
         */
        public String getLog()
        {
            return log;
        }

                                            
        /**
         * Set the value of Log
         *
         * @param v new value
         */
        public void setLog(String v) 
        {
          


         if (!ObjectUtils.equals(this.log, v))
        {
             this.log = v;
            setModified(true);
        }

                  
                       }


 
     
   
             
   
       private Weblog aWeblog;

    /**
     * Declares an association between this object and a Weblog object
     *
     * @param v Weblog
     * @throws TorqueException
     */
    public void setWeblog(Weblog v) throws TorqueException
    {
           if (v == null)
        {
                        setWeblogId(0);
                    }
        else
        {
            setWeblogId(v.getWeblogId());
        }
           aWeblog = v;
    }

                 
    /**
     * Get the associated Weblog object
     *
     * @return the associated Weblog object
     * @throws TorqueException
     */
    public Weblog getWeblog() throws TorqueException
    {
        if (aWeblog == null && (this.weblog_id > 0))
        {
              aWeblog = WeblogPeer.retrieveByPK(SimpleKey.keyFor(this.weblog_id));
      
            /* The following can be used instead of the line above to
               guarantee the related object contains a reference
               to this object, but this level of coupling
               may be undesirable in many circumstances.
               As it can lead to a db query with many results that may
               never be used.
               Weblog obj = WeblogPeer.retrieveByPK(this.weblog_id);
               obj.addWeblogTrackbacks(this);
             */
        }
        return aWeblog;
    }

    /**
     * Provides convenient way to set a relationship based on a
     * ObjectKey.  e.g.
     * <code>bar.setFooKey(foo.getPrimaryKey())</code>
     *
     */
    public void setWeblogKey(ObjectKey key) throws TorqueException
    {
    
                                        setWeblogId(((NumberKey) key).intValue());
                    }
    
        
    
    private static List fieldNames = null;

    /**
     * Generate a list of field names.
     *
     * @return a list of field names
     */
    public static synchronized List getFieldNames()
    {
      if (fieldNames == null)
      {
        fieldNames = new ArrayList();
            fieldNames.add("WeblogTrackbackId");
            fieldNames.add("WeblogId");
            fieldNames.add("Url");
            fieldNames.add("Name");
            fieldNames.add("Title");
            fieldNames.add("Overview");
            fieldNames.add("PostedDate");
            fieldNames.add("Log");
            fieldNames = Collections.unmodifiableList(fieldNames);
      }
      return fieldNames;
    }

    /**
     * Retrieves a field from the object by name passed in as a String.
     *
     * @param name field name
     * @return value
     */
    public Object getByName(String name)
    {
            if (name.equals("WeblogTrackbackId"))
    {
              return new Integer(getWeblogTrackbackId());
          }
            if (name.equals("WeblogId"))
    {
              return new Integer(getWeblogId());
          }
            if (name.equals("Url"))
    {
              return getUrl();
          }
            if (name.equals("Name"))
    {
              return getName();
          }
            if (name.equals("Title"))
    {
              return getTitle();
          }
            if (name.equals("Overview"))
    {
              return getOverview();
          }
            if (name.equals("PostedDate"))
    {
              return getPostedDate();
          }
            if (name.equals("Log"))
    {
              return getLog();
          }
            return null;
    }
    /**
     * Retrieves a field from the object by name passed in
     * as a String.  The String must be one of the static
     * Strings defined in this Class' Peer.
     *
     * @param name peer name
     * @return value
     */
    public Object getByPeerName(String name)
    {
            if (name.equals(WeblogTrackbackPeer.WEBLOG_TRACKBACK_ID))
        {
              return new Integer(getWeblogTrackbackId());
          }
            if (name.equals(WeblogTrackbackPeer.WEBLOG_ID))
        {
              return new Integer(getWeblogId());
          }
            if (name.equals(WeblogTrackbackPeer.URL))
        {
              return getUrl();
          }
            if (name.equals(WeblogTrackbackPeer.NAME))
        {
              return getName();
          }
            if (name.equals(WeblogTrackbackPeer.TITLE))
        {
              return getTitle();
          }
            if (name.equals(WeblogTrackbackPeer.OVERVIEW))
        {
              return getOverview();
          }
            if (name.equals(WeblogTrackbackPeer.POSTED_DATE))
        {
              return getPostedDate();
          }
            if (name.equals(WeblogTrackbackPeer.LOG))
        {
              return getLog();
          }
            return null;
    }

    /**
     * Retrieves a field from the object by Position as specified
     * in the xml schema.  Zero-based.
     *
     * @param pos position in xml schema
     * @return value
     */
    public Object getByPosition(int pos)
    {
            if (pos == 0)
    {
              return new Integer(getWeblogTrackbackId());
          }
            if (pos == 1)
    {
              return new Integer(getWeblogId());
          }
            if (pos == 2)
    {
              return getUrl();
          }
            if (pos == 3)
    {
              return getName();
          }
            if (pos == 4)
    {
              return getTitle();
          }
            if (pos == 5)
    {
              return getOverview();
          }
            if (pos == 6)
    {
              return getPostedDate();
          }
            if (pos == 7)
    {
              return getLog();
          }
                return null;
    }

     


    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     *
     * @throws Exception
     */
    public void save() throws Exception
    {
             save(WeblogTrackbackPeer.getMapBuilder()
                .getDatabaseMap().getName());
     }

    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     * Note: this code is here because the method body is
     * auto-generated conditionally and therefore needs to be
     * in this file instead of in the super class, BaseObject.
     *
     * @param dbName
     * @throws TorqueException
     */
    public void save(String dbName) throws TorqueException
    {
        Connection con = null;
         try
        {
            con = Transaction.begin(dbName);
            save(con);
            Transaction.commit(con);
        }
        catch(TorqueException e)
        {
            Transaction.safeRollback(con);
            throw e;
        }

     }

      /** flag to prevent endless save loop, if this object is referenced
        by another object which falls in this transaction. */
    private boolean alreadyInSave = false;
      /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.  This method
     * is meant to be used as part of a transaction, otherwise use
     * the save() method and the connection details will be handled
     * internally
     *
     * @param con
     * @throws TorqueException
     */
    public void save(Connection con) throws TorqueException
    {
        if (!alreadyInSave)
      {
        alreadyInSave = true;



  
        // If this object has been modified, then save it to the database.
        if (isModified())
        {
            if (isNew())
            {
                WeblogTrackbackPeer.doInsert((WeblogTrackback) this, con);
                setNew(false);
            }
            else
            {
                WeblogTrackbackPeer.doUpdate((WeblogTrackback) this, con);
            }
        }

              alreadyInSave = false;
      }
      }


                
    
    

        /**
     * Set the PrimaryKey using ObjectKey.
     *
     * @param  weblog_trackback_id ObjectKey
     */
    public void setPrimaryKey(ObjectKey key)
        
    {
                    setWeblogTrackbackId(((NumberKey) key).intValue());
            }

    /**
     * Set the PrimaryKey using a String.
     *
     * @param key
     */
    public void setPrimaryKey(String key) 
    {
                    setWeblogTrackbackId(Integer.parseInt(key));
            }


    /**
     * returns an id that differentiates this object from others
     * of its class.
     */
    public ObjectKey getPrimaryKey()
    {
        return SimpleKey.keyFor(getWeblogTrackbackId());
    }

 

    /**
     * Makes a copy of this object.
     * It creates a new object filling in the simple attributes.
     * It then fills all the association collections and sets the
     * related objects to isNew=true.
     */
    public WeblogTrackback copy() throws TorqueException
    {
        return copyInto(new WeblogTrackback());
    }

    protected WeblogTrackback copyInto(WeblogTrackback copyObj) throws TorqueException
    {
        copyObj.setWeblogTrackbackId(weblog_trackback_id);
        copyObj.setWeblogId(weblog_id);
        copyObj.setUrl(url);
        copyObj.setName(name);
        copyObj.setTitle(title);
        copyObj.setOverview(overview);
        copyObj.setPostedDate(posted_date);
        copyObj.setLog(log);

                      copyObj.setWeblogTrackbackId(0);
                                        

  
        return copyObj;
    }

    /**
     * returns a peer instance associated with this om.  Since Peer classes
     * are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     */
    public WeblogTrackbackPeer getPeer()
    {
        return peer;
    }
}
