package jp.sourceforge.jetspeedjapan.portlet.weblog.om;

/* ====================================================================================
 * Copyright (c) 2003, jetspeed-japan.sourceforge.jp
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *     * Redistributions of source code must retain the above copyright notice,
 *     * this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *     * notice, this list of conditions and the following disclaimer in the
 *     * documentation and/or other materials provided with the distribution.
 *     * Neither the name of the jetspeed-japan.sourceforge.jp nor the names 
 *       of its contributors
 *     * may be used to endorse or promote products derived from this software
 *     * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================================
 */

import java.sql.Connection;
import java.util.List;

import org.apache.torque.TorqueException;
import org.apache.torque.om.Persistent;
import org.apache.torque.util.Criteria;
import org.apache.turbine.util.Log;

/**
 * This class is the Object Model for Weblog table.
 * 
 * @author <a href="mailto:shinsuke@users.sourceforge.jp">Shinsuke Sugaya</a>
 */
public class Weblog extends jp.sourceforge.jetspeedjapan.portlet.weblog.om.BaseWeblog implements Persistent
{
    protected static final String CLASS_NAME = "jp.sourceforge.jetspeedjapan.portlet.weblog.om.Weblog";
    private List cachedWeblogMessages = null;

    /**
     * Returns the cached Web Log messages list.
     * 
     * @return  list for Web Log messages
     */
    public List getCachedWeblogMessages()
    {
        return cachedWeblogMessages;
    }

    /**
     * Sets Web Log messages to cache.
     */
    public void setCachedWeblogMessages()
    {
        Criteria crit = new Criteria();
        setCachedWeblogMessages(crit);
    }

    /**
     * Sets Web Log messages given by Criteria to cahce.
     * 
     * @param crit 
     */
    public void setCachedWeblogMessages(Criteria crit)
    {
        try
        {
            cachedWeblogMessages = getWeblogMessages(crit);
        }
        catch (TorqueException e)
        {
            Log.warn(CLASS_NAME + ": " + e.toString());
            cachedWeblogMessages = null;
        }
    }

    /**
     * Sets Web Log messages to cache.
     */
    public void setCachedWeblogMessages(Connection con)
    {
        Criteria crit = new Criteria();
        setCachedWeblogMessages(crit, con);
    }

    /**
     * Sets Web Log messages given by Criteria to cahce.
     * 
     * @param crit 
     */
    public void setCachedWeblogMessages(Criteria crit, Connection con)
    {
        try
        {
            cachedWeblogMessages = getWeblogMessages(crit, con);
        }
        catch (TorqueException e)
        {
            Log.warn(CLASS_NAME + ": " + e.toString());
            cachedWeblogMessages = null;
        }
    }
}
