package jp.sourceforge.jetspeedjapan.portlet.weblog.om;

/* ====================================================================================
 * Copyright (c) 2003, jetspeed-japan.sourceforge.jp
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *     * Redistributions of source code must retain the above copyright notice,
 *     * this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *     * notice, this list of conditions and the following disclaimer in the
 *     * documentation and/or other materials provided with the distribution.
 *     * Neither the name of the jetspeed-japan.sourceforge.jp nor the names 
 *       of its contributors
 *     * may be used to endorse or promote products derived from this software
 *     * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================================
 */

import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import jp.sourceforge.jetspeedjapan.portlet.weblog.WebLogException;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.torque.TorqueException;
import org.apache.torque.util.Criteria;

/** 
 * The skeleton for this class was autogenerated by Torque on:
 *
 * [Sun Jul 06 23:16:22 JST 2003]
 *
 *  You should add additional methods to this class to meet the
 *  application requirements.  This class will only be generated as
 *  long as it does not already exist in the output directory.
 */
public class WeblogMessagePeer extends jp.sourceforge.jetspeedjapan.portlet.weblog.om.BaseWeblogMessagePeer
{
    /**
     * Static initialization of the logger for this class
     */
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(WeblogMessagePeer.class.getName());

    public static List doSelectJoinWeblog(Criteria c) throws TorqueException
    {
        return BaseWeblogMessagePeer.doSelectJoinWeblog(c);
    }

    public static WeblogMessage add(Connection con, int wlogId, String title, String message, String format, Date d)
        throws WebLogException
    {
        // Insert WeblogMessage
        try
        {
            WeblogMessage dMessage = new WeblogMessage();
            if (wlogId > 0)
            {
                dMessage.setWeblogId(wlogId);
            }
            else
            {
                throw new WebLogException("Weblog ID error.");
            }
            if (title != null)
            {
                dMessage.setTitle(title);
            }
            if (message != null)
            {
                dMessage.setMessage(message);
            }
            if (format != null)
            {
                dMessage.setMessageFormatType(format);
            }
            if (d != null)
            {
                dMessage.setPostedDate(d);
            }
            else
            {
                Calendar cal = Calendar.getInstance();
                dMessage.setPostedDate(cal.getTime());
            }
            dMessage.save(con);

            return dMessage;
        }
        catch (TorqueException e)
        {
            logger.warn("add: " + e.toString());
            throw new WebLogException("Cannot create WeblogMessage data.", e);
        }
    }

    public static WeblogMessage update(
        Connection con,
        String owner,
        int id,
        int wlogId,
        String title,
        String message,
        String format,
        Date d)
        throws WebLogException
    {
        WeblogMessage dMessage = WeblogMessagePeer.getInstance(con, owner, id);
        if (dMessage == null)
        {
            throw new WebLogException("WeblogMessage(ID=" + id + ", OWNER=" + owner + ") does not exist.");
        }

        // Update WeblogMessage
        try
        {
            if (wlogId > 0)
            {
                dMessage.setWeblogId(wlogId);
            }
            if (title != null)
            {
                dMessage.setTitle(title);
            }
            if (message != null)
            {
                dMessage.setMessage(message);
            }
            if (format != null)
            {
                dMessage.setMessageFormatType(format);
            }
            if (d != null)
            {
                dMessage.setPostedDate(d);
            }
            dMessage.save(con);

            return dMessage;
        }
        catch (TorqueException e)
        {
            logger.warn("add: " + e.toString());
            throw new WebLogException("Cannot update WeblogMessage data. ", e);
        }
    }

    public static void delete(Connection con, String owner, int id) throws WebLogException
    {
        WeblogMessage dMessage = WeblogMessagePeer.getInstance(con, owner, id);
        if (dMessage == null)
        {
            throw new WebLogException("WeblogMessage(ID=" + id + ", OWNER=" + owner + ") does not exist.");
        }

        // Delete WeblogMessage
        try
        {
            WeblogMessagePeer.doDelete(dMessage, con);
        }

        catch (TorqueException e)
        {
            logger.warn("delete: " + e.toString());
            throw new WebLogException("Cannot delete WeblogMessage data.", e);
        }
    }

    /**
     * Gets WeblogMessage instance.
     * 
     * @param con
     * @param owner
     * @param id
     * @return
     * @throws WebLogException
     */
    public static WeblogMessage getInstance(Connection con, String owner, int id) throws WebLogException
    {
        Criteria crit = new Criteria();
        crit.add(WeblogPeer.OWNER, owner);
        crit.add(WeblogMessagePeer.WEBLOG_MESSAGE_ID, id);

        List l;
        try
        {
            l = WeblogMessagePeer.doSelectJoinWeblog(crit);
        }
        catch (TorqueException e)
        {
            logger.warn("getInstance: " + e.toString());
            throw new WebLogException("", e);
        }

        if (!l.isEmpty() && l.get(0) instanceof WeblogMessage)
        {
            return (WeblogMessage) (l.get(0));
        }
        return null;

    }

    /**
     * Gets Web Log message for the given date.
     */
    public static List getWeblogMessages(String owner, int year, int month, int day) throws WebLogException
    {
        Criteria crit = new Criteria();
        if (owner != null)
        {
            crit.add(WeblogPeer.OWNER, owner);
        }
        if (year > 0)
        {
            crit.add(WeblogPeer.YEAR, year);
        }
        if (month > 0)
        {
            crit.add(WeblogPeer.MONTH, month);
        }
        if (day > 0)
        {
            crit.add(WeblogPeer.DAY, day);
        }
        crit.addAscendingOrderByColumn(WeblogMessagePeer.POSTED_DATE);

        try
        {
            return WeblogMessagePeer.doSelectJoinWeblog(crit);
        }
        catch (TorqueException e)
        {
            throw new WebLogException("Cannot get WeblogMessage data.", e);
        }

    }
}
