﻿namespace CustomControls
{
   /// <summary>
   /// The hit test types of the <see cref="MonthCalendar"/>.
   /// </summary>
   public enum MonthCalendarHitType
   {
      /// <summary>
      /// Indicates a day.
      /// </summary>
      Day,

      /// <summary>
      /// Indicates a week.
      /// </summary>
      Week,

      /// <summary>
      /// Indicates a day name.
      /// </summary>
      DayName,

      /// <summary>
      /// Indicates the month name in the header.
      /// </summary>
      MonthName,

      /// <summary>
      /// Indicates the month year in the header.
      /// </summary>
      MonthYear,

      /// <summary>
      /// Indicates the header.
      /// </summary>
      Header,

      /// <summary>
      /// Indicates an arrow.
      /// </summary>
      Arrow,

      /// <summary>
      /// Indicates the footer.
      /// </summary>
      Footer,

      /// <summary>
      /// Indicates no type.
      /// </summary>
      None
   }
}