<?php

/**
 * Joomla! Content Management System
 *
 * @copyright  (C) 2019 Open Source Matters, Inc. <https://www.joomla.org>
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\CMS\Service\Provider;

use Joomla\CMS\User\UserFactory;
use Joomla\CMS\User\UserFactoryInterface;
use Joomla\Database\DatabaseInterface;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;

/**
 * Service provider for the user dependency
 *
 * @since  4.0.0
 */
class User implements ServiceProviderInterface
{
    /**
     * Registers the service provider with a DI container.
     *
     * @param   Container  $container  The DI container.
     *
     * @return  void
     *
     * @since   4.0.0
     */
    public function register(Container $container)
    {
        $container->alias('user.factory', UserFactoryInterface::class)
            ->alias(UserFactory::class, UserFactoryInterface::class)
            ->share(
                UserFactoryInterface::class,
                function (Container $container) {
                    return new UserFactory($container->get(DatabaseInterface::class));
                },
                true
            );
    }
}
