/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.maachang.reflect.FastReflectPrimitive;
import org.maachang.reflect.FastReflectUtil;

class FastConstructorElements {
    private final List<FastConstructorEmt> list = new ArrayList<FastConstructorEmt>();

    private FastConstructorElements() {
    }

    public FastConstructorElements(Class clazz) {
        Constructor<?>[] cs = clazz.getDeclaredConstructors();
        if (cs != null) {
            int len = cs.length;
            int i = 0;
            while (i < len) {
                Constructor<?> c = cs[i];
                if (Modifier.isPublic(c.getModifiers())) {
                    this.list.add(new FastConstructorEmt(c));
                }
                ++i;
            }
        }
    }

    protected void finalize() throws Exception {
        this.list.clear();
    }

    public Object newInstance(ClassLoader cl, Class[] types, Object[] args) throws ClassNotFoundException, InstantiationException, InvocationTargetException, IllegalAccessException {
        int argsLen;
        int len = this.list.size();
        int n = argsLen = args == null ? 0 : args.length;
        if (argsLen == 0) {
            int i = 0;
            while (i < len) {
                FastConstructorEmt emt = this.list.get(i);
                if (emt.paramsLength == 0) {
                    return emt.constructor.newInstance(FastReflectPrimitive.NO_PARAM);
                }
                ++i;
            }
        } else {
            int pf = 100 * argsLen;
            int score = -1;
            FastConstructorEmt targetEmt = null;
            int i = 0;
            while (i < len) {
                int sc;
                FastConstructorEmt emt = this.list.get(i);
                if (emt.paramsLength == argsLen && (sc = FastReflectUtil.parmasScore(emt.primitives, emt.params, types, cl)) != -1 && score < sc) {
                    if (sc == pf) {
                        return emt.constructor.newInstance(args);
                    }
                    score = sc;
                    targetEmt = emt;
                }
                ++i;
            }
            if (targetEmt != null) {
                args = FastReflectUtil.convertParams(args, targetEmt.params);
                return targetEmt.constructor.newInstance(args);
            }
        }
        return null;
    }

    private static class FastConstructorEmt {
        protected Constructor constructor;
        protected Class[] params;
        protected boolean[] primitives;
        protected int paramsLength;

        protected FastConstructorEmt(Constructor constructor) {
            int len;
            boolean[] pms = null;
            Class<?>[] args = constructor.getParameterTypes();
            int n = len = args == null ? 0 : args.length;
            if (len == 0) {
                args = FastReflectPrimitive.NO_PARAM_CLASS;
            } else {
                pms = new boolean[len];
                int i = 0;
                while (i < len) {
                    pms[i] = args[i].isPrimitive();
                    Class pc = FastReflectPrimitive.CONV_PRIMITIVE.get(args[i]);
                    if (pc != null) {
                        args[i] = pc;
                    }
                    ++i;
                }
            }
            constructor.setAccessible(true);
            this.constructor = constructor;
            this.params = args;
            this.primitives = pms;
            this.paramsLength = len;
        }
    }
}

