/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.reflect;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.maachang.reflect.JavaPackageList;

public abstract class FastPackageCache {
    protected static final long CACHE_TIMEOUT = 120000L;
    protected static final Map<String, FastPackageCacheChild> cache = new ConcurrentHashMap<String, FastPackageCacheChild>();
    protected static final FastPackageCacheThread cacheThread = new FastPackageCacheThread();

    private FastPackageCache() {
    }

    public static final List<String> getList(String packageName) throws Exception {
        FastPackageCacheChild ch;
        if (packageName == null || (packageName = packageName.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u30d1\u30c3\u30b1\u30fc\u30b8\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (packageName.endsWith(".")) {
            packageName = packageName.substring(0, packageName.length() - 1);
        }
        if ((ch = cache.get(packageName)) == null) {
            ch = new FastPackageCacheChild(packageName);
            cache.put(packageName, ch);
        }
        return ch.getList();
    }

    private static class FastPackageCacheThread
    extends Thread {
        public FastPackageCacheThread() {
            super.setDaemon(true);
            super.start();
        }

        @Override
        public void run() {
            long timeout = 120000L;
            Map<String, FastPackageCacheChild> map = cache;
            boolean endFlag = false;
            do {
                try {
                    Iterator<String> it = cache.keySet().iterator();
                    while (it.hasNext()) {
                        Thread.sleep(100L);
                        String key = it.next();
                        FastPackageCacheChild ch = map.get(key);
                        if (ch != null && ch.getUpdateTime() + timeout >= System.currentTimeMillis()) continue;
                        map.remove(key);
                    }
                }
                catch (InterruptedException it) {
                    endFlag = true;
                }
                catch (NullPointerException ne) {
                }
                catch (OutOfMemoryError mem) {
                }
                catch (Exception e) {
                }
                catch (ThreadDeath td) {
                    endFlag = true;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException it) {
                    endFlag = true;
                }
                catch (Exception e) {
                    // empty catch block
                }
            } while (!endFlag);
        }
    }

    private static class FastPackageCacheChild {
        private final List<String> list = new ArrayList<String>();
        private final AtomicLong lastAccess = new AtomicLong();

        public FastPackageCacheChild() {
        }

        public FastPackageCacheChild(String packageName) throws Exception {
            JavaPackageList.getInstance().getList(this.list, packageName);
            this.updateTime();
        }

        public void updateTime() {
            while (!this.lastAccess.compareAndSet(this.lastAccess.get(), System.currentTimeMillis())) {
            }
        }

        public long getUpdateTime() {
            return this.lastAccess.get();
        }

        public List<String> getList() {
            this.updateTime();
            return this.list;
        }

        public int size() {
            this.updateTime();
            return this.list.size();
        }
    }
}

