/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.reflect;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.maachang.reflect.FastClassElement;

abstract class FastReflectClass {
    private static final long WAIT_TIME = 15000L;
    protected static final Map<String, FastClassElement> cacheClass = new ConcurrentHashMap<String, FastClassElement>();
    protected static final FastReflectMon mon = new FastReflectMon();

    private FastReflectClass() {
    }

    public static final FastClassElement getClass(String name) throws ClassNotFoundException {
        Class<?> c;
        if (name == null || name.length() <= 0) {
            throw new IllegalArgumentException("\u30af\u30e9\u30b9\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        FastClassElement ret = cacheClass.get(name);
        if (ret == null && (c = Class.forName(name)) != null) {
            ret = new FastClassElement(c);
            cacheClass.put(name, ret);
        }
        if (ret != null) {
            ret.update();
        }
        return ret;
    }

    public static final FastClassElement getClass(ClassLoader cl, String name) throws ClassNotFoundException {
        Class<?> c;
        if (name == null || name.length() <= 0) {
            throw new IllegalArgumentException("\u30af\u30e9\u30b9\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        FastClassElement ret = cacheClass.get(name);
        if (ret == null && (c = cl == null ? Class.forName(name) : cl.loadClass(name)) != null) {
            ret = new FastClassElement(c);
            cacheClass.put(name, ret);
        }
        if (ret != null) {
            ret.update();
        }
        return ret;
    }

    private static class FastReflectMon
    extends Thread {
        FastReflectMon() {
            try {
                this.setDaemon(true);
                this.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            long WAIT = 15000L;
            while (true) {
                Map<String, FastClassElement> m = cacheClass;
                try {
                    Iterator<String> it = m.keySet().iterator();
                    while (it.hasNext()) {
                        Thread.sleep(50L);
                        String k = it.next();
                        FastClassElement v = m.get(k);
                        if (v == null || v.getLastAccessTime() + WAIT > System.currentTimeMillis()) continue;
                        m.remove(k);
                    }
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException ite) {
                }
                catch (NullPointerException ne) {
                    continue;
                }
                catch (OutOfMemoryError mem) {
                    continue;
                }
                catch (Exception e) {
                    continue;
                }
                break;
            }
        }
    }
}

