package org.maachang.reflect ;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

/**
 * フィールド要素群.
 *
 * @version 2009/03/29
 * @author  masahito suzuki
 * @since   FastReflect 1.00
 */
class FastFieldElements {
    /** フィールド格納Map. **/
    private final Map<String,Field> map = new HashMap<String,Field>() ;
    
    /**
     * コンストラクタ.
     */
    private FastFieldElements() {}
    
    /**
     * コンストラクタ.
     * @param clazz 対象のクラスオブジェクトを設定します.
     * @exception Exception 例外.
     */
    public FastFieldElements( Class clazz ) {
        Field[] fs = clazz.getDeclaredFields() ;
        if( fs != null ) {
            int len = fs.length ;
            for( int i = 0 ; i < len ; i ++ ) {
                // publicのみキャッシュ.
                Field f = fs[ i ] ;
                if( Modifier.isPublic( f.getModifiers() ) ) {
                    f.setAccessible( true ) ;
                    map.put( f.getName(),f ) ;
                }
            }
        }
    }
    
    /**
     * デストラクタ.
     */
    protected void finalize() throws Exception {
        map.clear() ;
    }
    
    /**
     * 指定名のフィールド情報を取得.
     * @param staticFlag [true]の場合、staticアクセス用として取得します.
     * @param name 対象のフィールド名を設定します.
     * @return Field 対象のフィールド情報が返されます.
     */
    public Field get( boolean staticFlag,String name ) {
        Field f = map.get( name ) ;
        if( f != null && Modifier.isStatic( f.getModifiers() ) == staticFlag ) {
            return f ;
        }
        return null ;
    }
}
