package org.maachang.reflect.test ;

import java.lang.reflect.Method;

import org.maachang.reflect.FastReflect;

// ベンチマーク.
public class TestBench {
    public static final void main( String[] args ) throws Exception {
        normalMain() ;
        normalRefletNoSearch() ;
        normalRefletSearch() ;
        fastReflect() ;
    }
    private static final void normalMain() throws Exception {
        System.out.println( "**** normalMain ****" ) ;
        long time = 0L ;
        for( int r = 0 ; r < 10 ; r ++ ) {
	        long t = System.currentTimeMillis() ;
	        for( int i = 0 ; i < 100000 ; i ++ ) {
	            Integer.parseInt( "100" ) ;
	        }
	        time += System.currentTimeMillis() - t ;
        }
        System.out.println( time ) ;
        System.out.println() ;
    }
    private static final void normalRefletNoSearch() throws Exception {
        System.out.println( "**** normalRefletNoSearch ****" ) ;
        Method m = Integer.class.getMethod( "parseInt",new Class[]{ String.class } ) ;
        long time = 0L ;
        for( int r = 0 ; r < 10 ; r ++ ) {
	        long t = System.currentTimeMillis() ;
	        for( int i = 0 ; i < 100000 ; i ++ ) {
	            m.invoke( null,"100" ) ;
	        }
	        time += System.currentTimeMillis() - t ;
        }
        System.out.println( time ) ;
        System.out.println() ;
    }
    
    private static final void normalRefletSearch() throws Exception {
        System.out.println( "**** normalRefletSearch ****" ) ;
        long time = 0L ;
        for( int r = 0 ; r < 10 ; r ++ ) {
        	long t = System.currentTimeMillis() ;
	        for( int i = 0 ; i < 100000 ; i ++ ) {
	            Method m = Integer.class.getMethod( "parseInt",new Class[]{ String.class } ) ;
	            m.invoke( null,"100" ) ;
	        }
	        time += System.currentTimeMillis() - t ;
        }
        System.out.println( time ) ;
        System.out.println() ;
    }
    
    private static final void fastReflect() throws Exception {
        System.out.println( "**** fastReflect ****" ) ;
        long time = 0L ;
        for( int r = 0 ; r < 10 ; r ++ ) {
	        long t = System.currentTimeMillis() ;
	        for( int i = 0 ; i < 100000 ; i ++ ) {
	            FastReflect.invoke( "java.lang.Integer",null,"parseInt","100" ) ;
	        }
	        time += System.currentTimeMillis() - t ;
        }
        System.out.println( time ) ;
        System.out.println() ;
    }
}

