package junkutil.gui;

import java.awt.Component;
import java.awt.Font;
import java.util.Iterator;
import java.util.Set;

import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

/**
 * LookAndFeel̐ݒ
 * @author Hiroyuki Shiota
 */
public class LzLookAndFeel {

    public static final String CLASSNAME_METAL = "javax.swing.plaf.metal.MetalLookAndFeel";
    public static final String CLASSNAME_MOTIF = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    public static final String CLASSNAME_WINDOWS = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    
    /**
     * RXgN^
     */
    private LzLookAndFeel() {
	}
    
    /**
     * VXeLaFɕς
     * @return
     */
    public static boolean toSystem() {
    	try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
			return true;
		} catch (Exception e) {
			return false;
		}
    }
    
    /**
     * NXvbgtH[LaFɕς
     * @return
     */
    public static boolean toCrossPlatform() {
    	try {
			UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
			return true;
		} catch (Exception e) {
			return false;
		}
    }
    
    /**
     * ^LaFɕς
     * @return
     */
    public static boolean toMetal() {
    	try {
			UIManager.setLookAndFeel(CLASSNAME_METAL);
			return true;
		} catch (Exception e) {
			return false;
		}
    }
    
    /**
     * `[tLaFɕς
     * @return
     */
    public static boolean toMotif() {
    	try {
			UIManager.setLookAndFeel(CLASSNAME_MOTIF);
			return true;
		} catch (Exception e) {
			return false;
		}
    }
    
    /**
     * WindowsLaFɕς
     * @return
     */
    public static boolean toWindows() {
    	try {
			UIManager.setLookAndFeel(CLASSNAME_WINDOWS);
			return true;
		} catch (Exception e) {
			return false;
		}
    }
    
    /**
     * Abvf[g
     * @param c
     */
    public static void update(Component c) {
    	if (c == null) return;
    	SwingUtilities.updateComponentTreeUI(c);
    }
    
    /**
     * VXeLaFg邩eXg
     * @return
     */
    public static boolean isAvailableSystem() {
    	return isAvailableLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }
    
    /**
     * NXvbgtH[LaFg邩eXg
     * @return
     */
    public static boolean isAvailableCrossPlatform() {
    	return isAvailableLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
    }
    
    /**
     * ^vbgtH[LaFg邩eXg
     * @return
     */
    public static boolean isAvailableMetal() {
    	return isAvailableLookAndFeel(CLASSNAME_METAL);
    }
    
    /**
     * `[tvbgtH[LaFg邩eXg
     * @return
     */
    public static boolean isAvailableMotif() {
    	return isAvailableLookAndFeel(CLASSNAME_MOTIF);
    }
    
    /**
     * WindowsvbgtH[LaFg邩eXg
     * @return
     */
    public static boolean isAvailableWindows() {
    	return isAvailableLookAndFeel(CLASSNAME_WINDOWS);
    }
    
    /**
     * LaFg邩eXg
     * @param lafName
     * @return
     */
    public static boolean isAvailableLookAndFeel(String lafName) {
        try {
            Class lnfClass = Class.forName(lafName);
            LookAndFeel laf = (LookAndFeel)(lnfClass.newInstance());
            return laf.isSupportedLookAndFeel();
        } catch (Exception e) {
            return false;
        }
    }
    
    /**
     * tHgݒ肷
     * @param font
     */
    public static void setFont(Font font) {
		LookAndFeel laf = UIManager.getLookAndFeel();
		Set keys = laf.getDefaults().keySet();
		for (Iterator it = keys.iterator(); it.hasNext();) {
			String key=it.next().toString();
			if (key.toLowerCase().indexOf("font") != -1) {
				UIManager.put(key, font);
			}
		}
	}
}
