package net.sourceforge.livepinger.crawler;
import java.util.ArrayList;
import java.util.List;

import net.sourceforge.livepinger.crawler.CrawlManager.OnCrawlDoneListener;
import net.sourceforge.livepinger.dto.Live;
import net.sourceforge.livepinger.extracter.CavetubeExtracter;
import net.sourceforge.livepinger.extracter.ExtracterBase;
import net.sourceforge.livepinger.extracter.LivetubeExtracter;


public class Crawler {
	
	/** N[ʒm󂯎郊Xi[ */
	OnCrawlDoneListener crawlDoneListener;
	

	public Crawler() {
	}

	public Crawler(OnCrawlDoneListener crawlDoneListener) {
		this.crawlDoneListener = crawlDoneListener;
	}
	
	/**
	 * @param args n/a
	 */
	public static void main(String[] args) {
		Crawler crawler = new Crawler();
		
		// N[Os
		try {
			List<Live> lives = new ArrayList<Live>();
			crawler.getPage(new CavetubeExtracter(), lives);
		} catch (CrawlException e) {
			System.out.println(Messages.getString("Crawler.error_crawl_general")); //$NON-NLS-1$
			e.printStackTrace();
		}
		
	}
	
	public void run() throws CrawlException {
		List<Live> lives = new ArrayList<Live>();
		
		getPage(new LivetubeExtracter(), lives);
		getPage(new CavetubeExtracter(), lives);
		
		// ʒmXi[Ăяo
		if (crawlDoneListener != null) {
			crawlDoneListener.onCrawlDone(lives);
		}
	}

	public void getPage(ExtracterBase extracter, List<Live> lives) throws CrawlException {
		RequestRunner runner = new RequestRunner(extracter.getCrawlUrl());
		String data = runner.getSimplePage();
		
		// 
		lives.addAll( extracter.extract(data) );
	}
}
