package net.sourceforge.livepinger.dto;

import java.awt.Image;


public abstract class Live {
	String url;
	String identifier;
	String name;
	boolean isOnair;
	
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	public String getIdentifier() {
		return identifier;
	}

	public void setIdentifier(String identifier) {
		this.identifier = identifier;
	}

	public String getUrl() {
		return url;
	}

	public boolean isOnair() {
		return isOnair;
	}

	public void setOnair(boolean isOnair) {
		this.isOnair = isOnair;
	}

	abstract public String getServiceName();
	
	abstract public Image getBackgroundImageInstance();

	public Live(String url, String identifier, String livename) {
		this.url = url;
		this.identifier = identifier;
		this.name = livename;
	}

	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("<html>");
		builder.append(identifier);
		builder.append("<br/>");
		builder.append(name);
		return builder.toString();
	}
	
	public static Live fromUrl(String url) {
		if (url.contains(LivetubeLive.BASE_URL)) {
			return new LivetubeLive(url, null, null);
		} else if (url.contains(CavetubeLive.BASE_URL)) {
			return new CavetubeLive(url, null, null);
		}
		return null;
	}
	
	/**
	 * URLzMҖєzM擾܂B
	 * KvΔzMy[W擾ĉ͂s܂
	 * y[W擾ۂ͕ʃXbhA
	 * ̃\bhnullԂ܂B
	 * @param url
	 * @return
	 * @throws UnsupportUrlException 
	 */
	public static Live resolveUrl(String url, OnResolveLiveDoneListener onResolveLiveDoneListener) throws UnsupportUrlException {
		if (url == null) return null;
		
		// TODO: s
		// URL̃p^[`FbNĔzMy[WȊOubNKv
		if (LivetubeLive.match(url)) {
			return new LivetubeLive(url, 
					LivetubeLive.getIdentifierFromUrl(url), 
					LivetubeLive.getLivenameFromUrl(url));
		} else if (CavetubeLive.match(url)) {
			CavetubeLive live = new CavetubeLive(url, "", "");
			live.crawlLivepage(onResolveLiveDoneListener);
			return null;
		}
		throw new UnsupportUrlException("T|[gĂȂURLłB");
	}
	
	public interface OnResolveLiveDoneListener {
		void onResolveLiveDone(Live live);
	}

}
