package net.sourceforge.livepinger.manager;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class ErrorDialog extends JDialog implements ActionListener {
	private static final long serialVersionUID = -884119769574232355L;
	
	/** G[e */
	String text;
	
	public static void main(String[] args) {
		try {
			ErrorDialog dialog = new ErrorDialog("G[e");
			dialog.setVisible(true);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public ErrorDialog(String text) throws HeadlessException {
		super();
		this.text = text;
		initialize();
	}
	
	/**
	 * G[_CAO\
	 * @param text
	 */
	public static void show(String text) {
		ErrorDialog dialog = new ErrorDialog(text);
		dialog.setVisible(true);
	}

	private void initialize() {
		setSize(300,160);
		setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
		setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
		
		getContentPane().setLayout(new BoxLayout(getContentPane(), BoxLayout.Y_AXIS));
		
		JTextArea textarea = new JTextArea();
		textarea.setEditable(false);
		textarea.setText(text);
		textarea.setOpaque(false);
		textarea.setPreferredSize(new Dimension(Integer.MAX_VALUE, 120));
		getContentPane().add(textarea);
		
		JPanel closePanel = new JPanel(new FlowLayout(FlowLayout.CENTER));
		closePanel.setPreferredSize(new Dimension(Integer.MAX_VALUE, 40));
		getContentPane().add(closePanel);
		
		JButton closeButton = new JButton("OK");
		closePanel.add(closeButton);
		closeButton.addActionListener(this);
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		dispose();
	}
	
}
