package net.sourceforge.livepinger.manager;

import java.awt.BorderLayout;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

import net.sourceforge.livepinger.crawler.CrawlManager;
import net.sourceforge.livepinger.crawler.CrawlManager.OnCrawlDoneListener;
import net.sourceforge.livepinger.crawler.CrawlManager.OnCrawlStartListener;
import net.sourceforge.livepinger.dto.Live;
import net.sourceforge.livepinger.dto.Live.OnResolveLiveDoneListener;
import net.sourceforge.livepinger.dto.LivetubeLive;
import net.sourceforge.livepinger.dto.UnsupportUrlException;
import net.sourceforge.livepinger.notifier.NotifierFrame;

public class Manager extends JFrame implements ActionListener, OnCrawlDoneListener, MouseListener, ListSelectionListener, OnCrawlStartListener {
	private static final long serialVersionUID = -364741433947806635L;
	
	public static String SOUND_FILENAME = "notifier.wav";
	
	/** Xbh쒆tO */
	boolean threadRunnning = false;
	
	/** N[Xbh */
	CrawlManager crawlManager;
	
	/** ʃe[u */
	TargetTable table;
	DefaultTableModel tableModel;
	
	/** oΏ۔zMꗗ */
	List<Live> targetLives = new ArrayList<Live>();
	
	/** N\ */
	JLabel initialLabel;
	
	/** ݒ{^ */
	JButton configureButton;
	/** XV{^ */
	JButton reloadButton;
	/** 폜{^ */
	JButton removeButton;
	/** J{^ */
	JButton openButton;
	
	
	public Manager(String arg0) throws HeadlessException {
		super(arg0);
		initialize();
	}

	private void initialize() {
		setSize(360,200);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
				
		initializeIcon();
		initializeToolPanel();
		
		// t@CΏۈꗗ𕜋A
		String[] columns = {"T[rX", "zM", ""};
		tableModel = new DefaultTableModel(columns, 0);
		try {
			targetLives = TargetFile.load();
			for (Live live: targetLives) {
				tableModel.addRow(new String[]{live.getServiceName(), live.getIdentifier()});
			}
		} catch (IOException e) {
			
		}
		
		initializeTable();
		
		setVisible(true);
		
		// N[XbhJn
		crawlManager = new CrawlManager(this, this); 
		crawlManager.start();
		crawlManager.startCrawl();
	}
	
	private void initializeIcon() {
		URL url = getClass().getResource("/images/icon.png");
		setIconImage(Toolkit.getDefaultToolkit().createImage(url));
	}

	private void initializeToolPanel() {
		JToolBar toolbar = new JToolBar();
		toolbar.setFloatable(false);
		
		reloadButton = new JButton();
		reloadButton.setFocusPainted(false);
		reloadButton.setPreferredSize(new Dimension(30, 30));
		reloadButton.setMinimumSize(new Dimension(30, 30));
		reloadButton.setMaximumSize(new Dimension(30, 30));
		reloadButton.addActionListener(new OnClickListener());
		URL url = getClass().getResource("/images/reload.png");
		reloadButton.setIcon(new ImageIcon(url));
		reloadButton.setToolTipText("XV");
		
		openButton = new JButton();
		openButton.setFocusPainted(false);
		openButton.setPreferredSize(new Dimension(30, 30));
		openButton.setMinimumSize(new Dimension(30, 30));
		openButton.setMaximumSize(new Dimension(30, 30));
		openButton.addActionListener(new OnClickListener());
		url = getClass().getResource("/images/open.png");
		openButton.setIcon(new ImageIcon(url));
		url = getClass().getResource("/images/open_disabled.png");
		openButton.setDisabledIcon(new ImageIcon(url));
		openButton.setToolTipText("uEUŊJ");
		openButton.setEnabled(false);
		
		removeButton = new JButton();
		removeButton.setFocusPainted(false);
		removeButton.setPreferredSize(new Dimension(30, 30));
		removeButton.setMinimumSize(new Dimension(30, 30));
		removeButton.setMaximumSize(new Dimension(30, 30));
		removeButton.addActionListener(new OnClickListener());
		url = getClass().getResource("/images/remove.png");
		removeButton.setIcon(new ImageIcon(url));
		url = getClass().getResource("/images/remove_disabled.png");
		removeButton.setDisabledIcon(new ImageIcon(url));
		removeButton.setToolTipText("폜");
		removeButton.setEnabled(false);
		
		configureButton = new JButton();
		configureButton.setFocusPainted(false);
		configureButton.setPreferredSize(new Dimension(30, 30));
		configureButton.setMinimumSize(new Dimension(30, 30));
		configureButton.setMaximumSize(new Dimension(30, 30));
		configureButton.addActionListener(new OnClickListener());
		url = getClass().getResource("/images/config.png");
		configureButton.setIcon(new ImageIcon(url));
		configureButton.setToolTipText("ݒ");
		
		toolbar.add(reloadButton);
		toolbar.addSeparator();
		toolbar.add(openButton);
		toolbar.add(removeButton);
		toolbar.addSeparator();
		toolbar.add(configureButton);
		
		getContentPane().add(toolbar , BorderLayout.NORTH);
	}

	
	private void initializeTable() {

		table = new TargetTable(tableModel, targetLives, this);
		table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
		table.setDefaultEditor(Object.class, null);
		KeyStroke keystroke = KeyStroke.getKeyStroke(KeyEvent.VK_DELETE, 0, false);
		table.registerKeyboardAction(this, keystroke, JComponent.WHEN_IN_FOCUSED_WINDOW);
		table.addMouseListener(this);
		
		table.getColumnModel().getColumn(0).setPreferredWidth( 120 );
		table.getColumnModel().getColumn(1).setPreferredWidth( 120 );
		table.getColumnModel().getColumn(2).setPreferredWidth( 80 );
		
		getContentPane().setDropTarget(new UrlDropTarget());
		getContentPane().add(new JScrollPane(table));
	}


	/**
	 * @param args
	 */
	public static void main(String[] args) {
		new Manager("livepinger ver.0.0.1");
	}
	
	class OnClickListener implements ActionListener {
		
		@Override
		public void actionPerformed(ActionEvent event) {
			if (event.getSource() == reloadButton) {
				crawlManager.startCrawl();
			} 
			else if (event.getSource() == openButton) {
				openSelectedRow();
			}
			else if (event.getSource() == removeButton) {
				removeSelectedRow();
			}
			else if (event.getSource() == configureButton) {
				new ConfigureFrame(getOwner(), "config livepinger");
			}
		}
	}

	
	class UrlDropTarget extends DropTarget implements OnResolveLiveDoneListener {
		private static final long serialVersionUID = -6644498608082348354L;
		
		public void drop(DropTargetDropEvent event) {
			event.acceptDrop(DnDConstants.ACTION_COPY_OR_MOVE);
			Transferable transData = event.getTransferable();
			try {
				String url = (String) transData.getTransferData(DataFlavor.stringFlavor);

				Live live = LivetubeLive.resolveUrl(url, this);
				onResolveLiveDone(live);
				
			} catch (UnsupportedFlavorException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (UnsupportUrlException e) {
				ErrorDialog.show(e.getMessage());
				e.printStackTrace();
			}
		}

		@Override
		public void onResolveLiveDone(Live live) {
			// ΉURLłȂ΃XLbv
			if (live == null) {
				return;
			}
			
			// dĂꍇ̓XLbv
			for (Live target: targetLives) {
				if (target.getClass().equals(live.getClass()) &&
						target.getIdentifier().equals(live.getIdentifier())) return;
			}
			
			Manager.this.targetLives.add(live);
			tableModel.addRow(new String[]{live.getServiceName(), live.getIdentifier()});
			
			// t@CɑΏۈꗗۑ
			try {
				TargetFile.save(targetLives);
			} catch (IOException e) {
				// TODO G[_CAO
				e.printStackTrace();
			}
			
			crawlManager.startCrawl();
		}
	}


	@Override
	public void onCrawlStart() {
		// zM󋵂̃NA
				for (int i = 0; i < targetLives.size(); i ++) {
					Live target = targetLives.get(i);
					
					tableModel.setValueAt("", i, 2);
					table.validate();
					table.repaint();
				}
	}

	@Override
	public void onCrawlDone(List<Live> lives) {
		int index = 0;
		boolean notificationFlag = false;
		
		// zMʎqΏ۔zMƈv̂ʒm
		for (int i=0; i<targetLives.size(); i++) {
			Live target = targetLives.get(i);
			Live foundLive = null;
			for (Live live: lives) {
				if (!live.getClass().equals(target.getClass())) continue;
				if (live.getIdentifier().equals(target.getIdentifier())) {
					foundLive = live;
					foundLive.setOnair(target.isOnair());
					targetLives.remove(i);
					targetLives.add(i, live);
					target = live;
					break;
				}
			}
			if (!target.isOnair() & foundLive != null) {
				new NotifierFrame(index++, target);
				notificationFlag = true;
			}
			target.setOnair(foundLive != null);
		}
		
		updateTableModel();
		
		if (notificationFlag) {
			playSound();
		}
		
		// t@CɑΏۈꗗۑ
		try {
			TargetFile.save(targetLives);
		} catch (IOException e) {
		}
	}
	
	private void updateTableModel() {
		// zM󋵂̍XV
		for (int i = 0; i < targetLives.size(); i ++) {
			Live target = targetLives.get(i);
			String value = (target.isOnair() ? "IGA[" : "ItC");
			
			tableModel.setValueAt(value, i, 2);
			table.validate();
			table.repaint();
		}
	}

	public void playSound() {
		try {
			File file = new File(SOUND_FILENAME);
			if (!file.exists()) {
				return;
			}
			
			AudioInputStream audioInputStream;
				audioInputStream = AudioSystem.getAudioInputStream(file);
			AudioFormat audioFormat = audioInputStream.getFormat();
			
            DataLine.Info info = new DataLine.Info(SourceDataLine.class,audioFormat);
            SourceDataLine line = (SourceDataLine) AudioSystem.getLine(info);
            line.open(audioFormat);
            line.start();
            
            int nBytesRead = 0;
            byte[] abData = new byte[1024];
            while (nBytesRead != -1) {
                // I[fBIXg[f[^ǂݍ݂܂
                nBytesRead = audioInputStream.read(abData, 0, abData.length);
                if (nBytesRead >= 0) {
                    // I[fBIf[^~LT[ɏ݂܂
                    line.write(abData, 0, nBytesRead);
                }
            }
            // CL[ɓĂf[^ro܂
            line.drain();
            // C܂
            line.close();
		} catch (UnsupportedAudioFileException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (LineUnavailableException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	@Override
	public void actionPerformed(ActionEvent event) {
		removeSelectedRow();
	}
	
	/**
	 * IĂzM폜At@Cɕۑ
	 */
	public void removeSelectedRow() {
		int[] rows = table.getSelectedRows();
		int deleteCount = 0;
		
		for (int row: rows) {
			int index = row - deleteCount;
			tableModel.removeRow(index);
			targetLives.remove(index);
			deleteCount ++;
		}
		
		// t@CɑΏۈꗗۑ
		try {
			TargetFile.save(targetLives);
		} catch (IOException e) {
		}
	}
	
	/**
	 * IĂzMuEUŊJ
	 * IĂꍇ͍ŏ̔zMΏۂƂ
	 */
	public void openSelectedRow() {
		int[] rows = table.getSelectedRows();
		if (rows.length == 0) return;
		
		int index = rows[0];
		if (index >= targetLives.size()) return;
		
		Live targetLive = targetLives.get(index);
		String url = targetLive.getUrl();
		Desktop desktop = Desktop.getDesktop();
        try {
			desktop.browse(new URI(url));
		} catch (IOException e) {
		} catch (URISyntaxException e) {
		}
	}

	@Override
	public void mouseClicked(MouseEvent event) {
		if(event.getClickCount()==2) {
			Point pt = event.getPoint();
			int index = table.rowAtPoint(pt);
			if (index >= targetLives.size()) return;
			
			Live targetLive = targetLives.get(index);
			String url = targetLive.getUrl();
			
			Desktop desktop = Desktop.getDesktop();
	        try {
				desktop.browse(new URI(url));
			} catch (IOException e) {
			} catch (URISyntaxException e) {
			}
		}
	}

	@Override
	public void mouseEntered(MouseEvent arg0) {
	}

	@Override
	public void mouseExited(MouseEvent arg0) {
	}

	@Override
	public void mousePressed(MouseEvent arg0) {
	}

	@Override
	public void mouseReleased(MouseEvent arg0) {
	}

	@Override
	public void valueChanged(ListSelectionEvent e) {
		int[] rows = table.getSelectedRows();
		boolean selected = (rows.length != 0);
		
		openButton.setEnabled(selected);
		removeButton.setEnabled(selected);
	}
	
}
