/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.livepinger.crawler;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.livepinger.crawler.CrawlException;
import net.sourceforge.livepinger.crawler.CrawlManager;
import net.sourceforge.livepinger.crawler.Messages;
import net.sourceforge.livepinger.crawler.RequestRunner;
import net.sourceforge.livepinger.dto.Live;
import net.sourceforge.livepinger.extracter.CavetubeExtracter;
import net.sourceforge.livepinger.extracter.ExtracterBase;
import net.sourceforge.livepinger.extracter.LivetubeExtracter;

public class Crawler {
    CrawlManager.OnCrawlDoneListener crawlDoneListener;

    public Crawler() {
    }

    public Crawler(CrawlManager.OnCrawlDoneListener crawlDoneListener) {
        this.crawlDoneListener = crawlDoneListener;
    }

    public static void main(String[] args) {
        Crawler crawler = new Crawler();
        try {
            ArrayList<Live> lives = new ArrayList<Live>();
            crawler.getPage(new CavetubeExtracter(), lives);
        }
        catch (CrawlException e) {
            System.out.println(Messages.getString("Crawler.error_crawl_general"));
            e.printStackTrace();
        }
    }

    public void run() throws CrawlException {
        ArrayList<Live> lives = new ArrayList<Live>();
        this.getPage(new LivetubeExtracter(), lives);
        this.getPage(new CavetubeExtracter(), lives);
        if (this.crawlDoneListener != null) {
            this.crawlDoneListener.onCrawlDone(lives);
        }
    }

    public void getPage(ExtracterBase extracter, List<Live> lives) throws CrawlException {
        RequestRunner runner = new RequestRunner(extracter.getCrawlUrl());
        String data = runner.getSimplePage();
        lives.addAll(extracter.extract(data));
    }
}

