/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.livepinger.extracter;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.livepinger.dto.CavetubeLive;
import net.sourceforge.livepinger.dto.Live;
import net.sourceforge.livepinger.extracter.ExtracterBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CavetubeExtracter
extends ExtracterBase {
    private static Log log = LogFactory.getLog(CavetubeExtracter.class);
    static String CRAWL_URL = "http://gae.cavelis.net/";
    Pattern urlPattern = Pattern.compile("<a class=\"stream_link\" href= \"/([^\"]+)\"><span class=\"stream_title\">([^<$]*)</span></a>");
    Pattern identifierPattern = Pattern.compile("<a class=\"author_link\" href=\"/user/([^\"]+)\"><strong class=\"author\">([^<$]*)</strong></a>");

    @Override
    public List<Live> extract(String data) {
        ArrayList<Live> lives = new ArrayList<Live>();
        Matcher urlMatcher = this.urlPattern.matcher(data);
        while (urlMatcher.find()) {
            try {
                String liveName = URLDecoder.decode(urlMatcher.group(2), "UTF-8");
                log.info("[extract] live: " + liveName);
                CavetubeLive live = new CavetubeLive(String.valueOf(CRAWL_URL) + urlMatcher.group(1), null, liveName);
                live.setOnair(true);
                lives.add(live);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        Matcher identifierMatcher = this.identifierPattern.matcher(data);
        int index = 0;
        while (identifierMatcher.find()) {
            if (index >= lives.size()) {
                log.error("[cavetube extracter] identifier extraction outofindex " + index);
                break;
            }
            try {
                String distName = URLDecoder.decode(identifierMatcher.group(2), "UTF-8");
                log.info("[extract] distributor: " + distName);
                Live live = (Live)lives.get(index);
                live.setIdentifier(distName);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            ++index;
        }
        return lives;
    }

    @Override
    public String getCrawlUrl() {
        return CRAWL_URL;
    }
}

