/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.livepinger.manager;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import net.sourceforge.livepinger.crawler.CrawlManager;
import net.sourceforge.livepinger.dto.Live;
import net.sourceforge.livepinger.dto.LivetubeLive;
import net.sourceforge.livepinger.dto.UnsupportUrlException;
import net.sourceforge.livepinger.manager.ConfigureFrame;
import net.sourceforge.livepinger.manager.ErrorDialog;
import net.sourceforge.livepinger.manager.TargetFile;
import net.sourceforge.livepinger.manager.TargetTable;
import net.sourceforge.livepinger.notifier.NotifierFrame;

public class Manager
extends JFrame
implements ActionListener,
CrawlManager.OnCrawlDoneListener,
MouseListener,
ListSelectionListener,
CrawlManager.OnCrawlStartListener {
    private static final long serialVersionUID = -364741433947806635L;
    public static String SOUND_FILENAME = "notifier.wav";
    boolean threadRunnning = false;
    CrawlManager crawlManager;
    TargetTable table;
    DefaultTableModel tableModel;
    List<Live> targetLives = new ArrayList<Live>();
    JLabel initialLabel;
    JButton configureButton;
    JButton reloadButton;
    JButton removeButton;
    JButton openButton;

    public Manager(String arg0) throws HeadlessException {
        super(arg0);
        this.initialize();
    }

    private void initialize() {
        this.setSize(360, 200);
        this.setDefaultCloseOperation(3);
        this.initializeIcon();
        this.initializeToolPanel();
        Object[] columns = new String[]{"\u30b5\u30fc\u30d3\u30b9", "\u914d\u4fe1\u8005", "\u72b6\u6cc1"};
        this.tableModel = new DefaultTableModel(columns, 0);
        try {
            this.targetLives = TargetFile.load();
            for (Live live : this.targetLives) {
                this.tableModel.addRow(new String[]{live.getServiceName(), live.getIdentifier()});
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.initializeTable();
        this.setVisible(true);
        this.crawlManager = new CrawlManager(this, this);
        this.crawlManager.start();
        this.crawlManager.startCrawl();
    }

    private void initializeIcon() {
        URL url = this.getClass().getResource("/images/icon.png");
        this.setIconImage(Toolkit.getDefaultToolkit().createImage(url));
    }

    private void initializeToolPanel() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        this.reloadButton = new JButton();
        this.reloadButton.setFocusPainted(false);
        this.reloadButton.setPreferredSize(new Dimension(30, 30));
        this.reloadButton.setMinimumSize(new Dimension(30, 30));
        this.reloadButton.setMaximumSize(new Dimension(30, 30));
        this.reloadButton.addActionListener(new OnClickListener());
        URL url = this.getClass().getResource("/images/reload.png");
        this.reloadButton.setIcon(new ImageIcon(url));
        this.reloadButton.setToolTipText("\u66f4\u65b0");
        this.openButton = new JButton();
        this.openButton.setFocusPainted(false);
        this.openButton.setPreferredSize(new Dimension(30, 30));
        this.openButton.setMinimumSize(new Dimension(30, 30));
        this.openButton.setMaximumSize(new Dimension(30, 30));
        this.openButton.addActionListener(new OnClickListener());
        url = this.getClass().getResource("/images/open.png");
        this.openButton.setIcon(new ImageIcon(url));
        url = this.getClass().getResource("/images/open_disabled.png");
        this.openButton.setDisabledIcon(new ImageIcon(url));
        this.openButton.setToolTipText("\u30d6\u30e9\u30a6\u30b6\u3067\u958b\u304f");
        this.openButton.setEnabled(false);
        this.removeButton = new JButton();
        this.removeButton.setFocusPainted(false);
        this.removeButton.setPreferredSize(new Dimension(30, 30));
        this.removeButton.setMinimumSize(new Dimension(30, 30));
        this.removeButton.setMaximumSize(new Dimension(30, 30));
        this.removeButton.addActionListener(new OnClickListener());
        url = this.getClass().getResource("/images/remove.png");
        this.removeButton.setIcon(new ImageIcon(url));
        url = this.getClass().getResource("/images/remove_disabled.png");
        this.removeButton.setDisabledIcon(new ImageIcon(url));
        this.removeButton.setToolTipText("\u524a\u9664");
        this.removeButton.setEnabled(false);
        this.configureButton = new JButton();
        this.configureButton.setFocusPainted(false);
        this.configureButton.setPreferredSize(new Dimension(30, 30));
        this.configureButton.setMinimumSize(new Dimension(30, 30));
        this.configureButton.setMaximumSize(new Dimension(30, 30));
        this.configureButton.addActionListener(new OnClickListener());
        url = this.getClass().getResource("/images/config.png");
        this.configureButton.setIcon(new ImageIcon(url));
        this.configureButton.setToolTipText("\u8a2d\u5b9a");
        toolbar.add(this.reloadButton);
        toolbar.addSeparator();
        toolbar.add(this.openButton);
        toolbar.add(this.removeButton);
        toolbar.addSeparator();
        toolbar.add(this.configureButton);
        this.getContentPane().add((Component)toolbar, "North");
    }

    private void initializeTable() {
        this.table = new TargetTable((TableModel)this.tableModel, this.targetLives, this);
        this.table.setAutoResizeMode(0);
        this.table.setDefaultEditor(Object.class, null);
        KeyStroke keystroke = KeyStroke.getKeyStroke(127, 0, false);
        this.table.registerKeyboardAction(this, keystroke, 2);
        this.table.addMouseListener(this);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(120);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(120);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(80);
        this.getContentPane().setDropTarget(new UrlDropTarget());
        this.getContentPane().add(new JScrollPane(this.table));
    }

    public static void main(String[] args) {
        new Manager("livepinger ver.0.0.1");
    }

    @Override
    public void onCrawlStart() {
        int i = 0;
        while (i < this.targetLives.size()) {
            Live target = this.targetLives.get(i);
            this.tableModel.setValueAt("", i, 2);
            this.table.validate();
            this.table.repaint();
            ++i;
        }
    }

    @Override
    public void onCrawlDone(List<Live> lives) {
        int index = 0;
        boolean notificationFlag = false;
        int i = 0;
        while (i < this.targetLives.size()) {
            Live target = this.targetLives.get(i);
            Live foundLive = null;
            for (Live live : lives) {
                if (!live.getClass().equals(target.getClass()) || !live.getIdentifier().equals(target.getIdentifier())) continue;
                foundLive = live;
                foundLive.setOnair(target.isOnair());
                this.targetLives.remove(i);
                this.targetLives.add(i, live);
                target = live;
                break;
            }
            if (!target.isOnair() & foundLive != null) {
                new NotifierFrame(index++, target);
                notificationFlag = true;
            }
            target.setOnair(foundLive != null);
            ++i;
        }
        this.updateTableModel();
        if (notificationFlag) {
            this.playSound();
        }
        try {
            TargetFile.save(this.targetLives);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void updateTableModel() {
        int i = 0;
        while (i < this.targetLives.size()) {
            Live target = this.targetLives.get(i);
            String value = target.isOnair() ? "\u30aa\u30f3\u30a8\u30a2\u30fc" : "\u30aa\u30d5\u30e9\u30a4\u30f3";
            this.tableModel.setValueAt(value, i, 2);
            this.table.validate();
            this.table.repaint();
            ++i;
        }
    }

    public void playSound() {
        try {
            File file = new File(SOUND_FILENAME);
            if (!file.exists()) {
                return;
            }
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(file);
            AudioFormat audioFormat = audioInputStream.getFormat();
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
            SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);
            line.open(audioFormat);
            line.start();
            int nBytesRead = 0;
            byte[] abData = new byte[1024];
            while (nBytesRead != -1) {
                nBytesRead = audioInputStream.read(abData, 0, abData.length);
                if (nBytesRead < 0) continue;
                line.write(abData, 0, nBytesRead);
            }
            line.drain();
            line.close();
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.removeSelectedRow();
    }

    public void removeSelectedRow() {
        int[] rows = this.table.getSelectedRows();
        int deleteCount = 0;
        int[] nArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            int row = nArray[n2];
            int index = row - deleteCount;
            this.tableModel.removeRow(index);
            this.targetLives.remove(index);
            ++deleteCount;
            ++n2;
        }
        try {
            TargetFile.save(this.targetLives);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void openSelectedRow() {
        int[] rows = this.table.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        int index = rows[0];
        if (index >= this.targetLives.size()) {
            return;
        }
        Live targetLive = this.targetLives.get(index);
        String url = targetLive.getUrl();
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.browse(new URI(url));
        }
        catch (IOException iOException) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (event.getClickCount() == 2) {
            Point pt = event.getPoint();
            int index = this.table.rowAtPoint(pt);
            if (index >= this.targetLives.size()) {
                return;
            }
            Live targetLive = this.targetLives.get(index);
            String url = targetLive.getUrl();
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(new URI(url));
            }
            catch (IOException iOException) {
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int[] rows = this.table.getSelectedRows();
        boolean selected = rows.length != 0;
        this.openButton.setEnabled(selected);
        this.removeButton.setEnabled(selected);
    }

    class OnClickListener
    implements ActionListener {
        OnClickListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == Manager.this.reloadButton) {
                Manager.this.crawlManager.startCrawl();
            } else if (event.getSource() == Manager.this.openButton) {
                Manager.this.openSelectedRow();
            } else if (event.getSource() == Manager.this.removeButton) {
                Manager.this.removeSelectedRow();
            } else if (event.getSource() == Manager.this.configureButton) {
                new ConfigureFrame(Manager.this.getOwner(), "config livepinger");
            }
        }
    }

    class UrlDropTarget
    extends DropTarget
    implements Live.OnResolveLiveDoneListener {
        private static final long serialVersionUID = -6644498608082348354L;

        UrlDropTarget() {
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            event.acceptDrop(3);
            Transferable transData = event.getTransferable();
            try {
                String url = (String)transData.getTransferData(DataFlavor.stringFlavor);
                Live live = LivetubeLive.resolveUrl(url, this);
                this.onResolveLiveDone(live);
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (UnsupportUrlException e) {
                ErrorDialog.show(e.getMessage());
                e.printStackTrace();
            }
        }

        @Override
        public void onResolveLiveDone(Live live) {
            if (live == null) {
                return;
            }
            for (Live target : Manager.this.targetLives) {
                if (!target.getClass().equals(live.getClass()) || !target.getIdentifier().equals(live.getIdentifier())) continue;
                return;
            }
            Manager.this.targetLives.add(live);
            Manager.this.tableModel.addRow(new String[]{live.getServiceName(), live.getIdentifier()});
            try {
                TargetFile.save(Manager.this.targetLives);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Manager.this.crawlManager.startCrawl();
        }
    }
}

