/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.livepinger.dto;

import java.awt.Image;
import net.sourceforge.livepinger.dto.CavetubeLive;
import net.sourceforge.livepinger.dto.LivetubeLive;
import net.sourceforge.livepinger.dto.NiconamaLive;
import net.sourceforge.livepinger.dto.UnsupportUrlException;

public abstract class Live {
    String url;
    String identifier;
    String name;
    boolean isOnair;
    Integer listener;
    Integer viewer;
    Integer commentCount;

    public Integer getListener() {
        return this.listener;
    }

    public void setListener(Integer listener) {
        this.listener = listener;
    }

    public Integer getViewer() {
        return this.viewer;
    }

    public void setViewer(Integer viewer) {
        this.viewer = viewer;
    }

    public Integer getCommentCount() {
        return this.commentCount;
    }

    public void setCommentCount(Integer commentCount) {
        this.commentCount = commentCount;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isOnair() {
        return this.isOnair;
    }

    public void setOnair(boolean isOnair) {
        this.isOnair = isOnair;
    }

    public String getDisplayIdentifier() {
        return this.identifier;
    }

    public boolean match(Live live) {
        if (this.getIdentifier() == null) {
            return false;
        }
        if (live == null || live.getIdentifier() == null) {
            return false;
        }
        return this.getIdentifier().equals(live.getIdentifier());
    }

    public abstract String getServiceName();

    public abstract Image getBackgroundImageInstance();

    public Live(String url, String identifier, String livename) {
        this.url = url;
        this.identifier = identifier;
        this.name = livename;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<html>");
        builder.append(this.getDisplayIdentifier());
        builder.append("<br/>");
        builder.append(this.name);
        return builder.toString();
    }

    public static Live fromUrl(String url) {
        if (url.contains(LivetubeLive.BASE_URL)) {
            return new LivetubeLive(url, null, null);
        }
        if (url.contains(CavetubeLive.BASE_URL)) {
            return new CavetubeLive(url, null, null);
        }
        if (url.contains(NiconamaLive.BASE_URL)) {
            return new NiconamaLive(url, null, null);
        }
        return null;
    }

    public static Live resolveUrl(String url, OnResolveLiveDoneListener onResolveLiveDoneListener) throws UnsupportUrlException {
        if (url == null) {
            return null;
        }
        if (LivetubeLive.match(url)) {
            return new LivetubeLive(url, LivetubeLive.getIdentifierFromUrl(url), LivetubeLive.getLivenameFromUrl(url));
        }
        if (CavetubeLive.match(url)) {
            CavetubeLive live = new CavetubeLive(url, "", "");
            live.crawlLivepage(onResolveLiveDoneListener);
            return null;
        }
        if (NiconamaLive.match(url)) {
            NiconamaLive live = new NiconamaLive(url, "", "");
            live.crawlLivepage(onResolveLiveDoneListener);
            return null;
        }
        throw new UnsupportUrlException();
    }

    public static interface OnResolveLiveDoneListener {
        public void onResolveLiveDone(Live var1);

        public void onResolveLiveFailure(String var1);
    }
}

