/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.livepinger.dto;

import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.livepinger.crawler.RequestRunner;
import net.sourceforge.livepinger.dto.Live;
import net.sourceforge.livepinger.dto.ResolveFailureException;
import net.sourceforge.livepinger.dto.UnsupportUrlException;

public class NiconamaLive
extends Live
implements RequestRunner.OnRequestDoneListener {
    public static String SERVICE_NAME = "\u30cb";
    public static String BASE_URL = "http://live.nicovideo.jp/";
    private static final String BACKGROUND_IMAGE_PATH = "/images/notifier_bg_niconama.png";
    private static Image backgroundImage = null;
    static Pattern URL_PATTERN = Pattern.compile("http://live\\.nicovideo\\.jp/watch/[^/]+");
    static Pattern ERROR_PATTERN = Pattern.compile("\u30a8\u30e9\u30fc");
    static Pattern LIVENAME_PATTERN = Pattern.compile("<title>(.*?) - \u30cb\u30b3\u30cb\u30b3\u751f\u653e\u9001</title>");
    static Pattern IDENTIFIER_PATTERN = Pattern.compile("<a href=\"http://(com|ch).nicovideo.jp/(community|channel)/([^\"]+)\" target=\"_blank\">");
    Live.OnResolveLiveDoneListener onResolveLiveDoneListener;

    public NiconamaLive(String url, String identifier, String livename) {
        super(url, identifier, livename);
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public synchronized Image getBackgroundImageInstance() {
        if (backgroundImage == null) {
            URL url = NiconamaLive.class.getResource(BACKGROUND_IMAGE_PATH);
            backgroundImage = Toolkit.getDefaultToolkit().getImage(url);
        }
        return backgroundImage;
    }

    public void crawlLivepage(Live.OnResolveLiveDoneListener onResolveLiveDoneListener) {
        this.onResolveLiveDoneListener = onResolveLiveDoneListener;
        RequestRunner runner = new RequestRunner(this.getUrl(), this);
        runner.start();
    }

    @Override
    public void onRequestDone(RequestRunner runner, String data) {
        Matcher errorPageMatcher = ERROR_PATTERN.matcher(data);
        if (errorPageMatcher.find()) {
            if (this.onResolveLiveDoneListener != null) {
                this.onResolveLiveDoneListener.onResolveLiveFailure(ResolveFailureException.MESSAGE);
            }
            return;
        }
        Matcher livenameMatcher = LIVENAME_PATTERN.matcher(data);
        if (!livenameMatcher.find()) {
            if (this.onResolveLiveDoneListener != null) {
                this.onResolveLiveDoneListener.onResolveLiveFailure(UnsupportUrlException.MESSAGE);
            }
            return;
        }
        this.setName(livenameMatcher.group(1));
        Matcher identifierMatcher = IDENTIFIER_PATTERN.matcher(data);
        if (!identifierMatcher.find()) {
            if (this.onResolveLiveDoneListener != null) {
                this.onResolveLiveDoneListener.onResolveLiveFailure("\u914d\u4fe1\u8005\u3092\u7279\u5b9a\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            }
            return;
        }
        this.setIdentifier(identifierMatcher.group(3));
        if (this.onResolveLiveDoneListener != null) {
            this.onResolveLiveDoneListener.onResolveLiveDone(this);
        }
    }

    public static boolean match(String url) {
        return URL_PATTERN.matcher(url).matches();
    }

    @Override
    public String getDisplayIdentifier() {
        if (this.getIdentifier() == null) {
            return "";
        }
        String[] parts = this.getIdentifier().split("/");
        if (parts.length == 0) {
            return "";
        }
        return parts[0];
    }

    public String getNiconamaIdentifier() {
        if (this.getIdentifier() == null) {
            return null;
        }
        String[] parts = this.getIdentifier().split("/");
        if (parts.length == 0) {
            return "";
        }
        if (parts.length == 1) {
            return parts[0];
        }
        return parts[1];
    }

    @Override
    public boolean match(Live live) {
        if (this.getIdentifier() == null) {
            return false;
        }
        if (live == null || live.getIdentifier() == null) {
            return false;
        }
        if (!(live instanceof NiconamaLive)) {
            return false;
        }
        return this.getNiconamaIdentifier().equals(((NiconamaLive)live).getNiconamaIdentifier());
    }
}

