/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.livepinger.manager;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import net.sourceforge.livepinger.crawler.CrawlManager;
import net.sourceforge.livepinger.crawler.Crawler;
import net.sourceforge.livepinger.crawler.OnCrawlDoneListener;
import net.sourceforge.livepinger.dto.Live;
import net.sourceforge.livepinger.dto.UnsupportUrlException;
import net.sourceforge.livepinger.extracter.CavetubeExtracter;
import net.sourceforge.livepinger.extracter.ExtracterBase;
import net.sourceforge.livepinger.extracter.LivetubeExtracter;
import net.sourceforge.livepinger.extracter.NiconamaExtracter;
import net.sourceforge.livepinger.manager.ConfigureFrame;
import net.sourceforge.livepinger.manager.ErrorDialog;
import net.sourceforge.livepinger.manager.SoundPlayer;
import net.sourceforge.livepinger.manager.TargetFile;
import net.sourceforge.livepinger.manager.TargetTable;
import net.sourceforge.livepinger.notifier.NotifierFrame;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Manager
extends JFrame
implements ActionListener,
OnCrawlDoneListener,
MouseListener,
ListSelectionListener,
Crawler.OnCrawlStartListener,
NotifierFrame.OnEndNotifierListener {
    private static final long serialVersionUID = -364741433947806635L;
    private static Log log = LogFactory.getLog(Manager.class);
    public static String SOUND_FILENAME = "notifier.wav";
    boolean threadRunnning = false;
    CrawlManager crawlManager;
    TargetTable table;
    DefaultTableModel tableModel;
    int notifierIndex = 0;
    List<Live> targetLives = new CopyOnWriteArrayList<Live>();
    JLabel initialLabel;
    JButton configureButton;
    JButton reloadButton;
    JButton removeButton;
    JButton openButton;

    public Manager(String arg0) throws HeadlessException {
        super(arg0);
        this.initialize();
    }

    private void initialize() {
        this.setSize(410, 200);
        this.setDefaultCloseOperation(3);
        this.initializeIcon();
        this.initializeToolPanel();
        Object[] columns = new String[]{"", "\u914d\u4fe1\u8005", "\u8996\u8074", "\u30b3\u30e1", "\u72b6\u6cc1"};
        this.tableModel = new DefaultTableModel(columns, 0);
        try {
            this.targetLives = TargetFile.load();
            for (Live live : this.targetLives) {
                this.tableModel.addRow(new String[]{live.getServiceName(), live.getDisplayIdentifier()});
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.initializeTable();
        this.setVisible(true);
        this.crawlManager = new CrawlManager();
        this.crawlManager.register(new Crawler(this.targetLives, new LivetubeExtracter(), this, this));
        this.crawlManager.register(new Crawler(this.targetLives, new CavetubeExtracter(), this, this));
        this.crawlManager.register(new Crawler(this.targetLives, new NiconamaExtracter(), this, this));
        this.crawlManager.start();
        this.crawlManager.startCrawl();
    }

    private void initializeIcon() {
        URL url = this.getClass().getResource("/images/icon.png");
        this.setIconImage(Toolkit.getDefaultToolkit().createImage(url));
    }

    private void initializeToolPanel() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        this.reloadButton = new JButton();
        this.reloadButton.setFocusPainted(false);
        this.reloadButton.setPreferredSize(new Dimension(30, 30));
        this.reloadButton.setMinimumSize(new Dimension(30, 30));
        this.reloadButton.setMaximumSize(new Dimension(30, 30));
        this.reloadButton.addActionListener(new OnClickListener());
        URL url = this.getClass().getResource("/images/reload.png");
        this.reloadButton.setIcon(new ImageIcon(url));
        this.reloadButton.setToolTipText("\u66f4\u65b0");
        this.openButton = new JButton();
        this.openButton.setFocusPainted(false);
        this.openButton.setPreferredSize(new Dimension(30, 30));
        this.openButton.setMinimumSize(new Dimension(30, 30));
        this.openButton.setMaximumSize(new Dimension(30, 30));
        this.openButton.addActionListener(new OnClickListener());
        url = this.getClass().getResource("/images/open.png");
        this.openButton.setIcon(new ImageIcon(url));
        url = this.getClass().getResource("/images/open_disabled.png");
        this.openButton.setDisabledIcon(new ImageIcon(url));
        this.openButton.setToolTipText("\u30d6\u30e9\u30a6\u30b6\u3067\u958b\u304f");
        this.openButton.setEnabled(false);
        this.removeButton = new JButton();
        this.removeButton.setFocusPainted(false);
        this.removeButton.setPreferredSize(new Dimension(30, 30));
        this.removeButton.setMinimumSize(new Dimension(30, 30));
        this.removeButton.setMaximumSize(new Dimension(30, 30));
        this.removeButton.addActionListener(new OnClickListener());
        url = this.getClass().getResource("/images/remove.png");
        this.removeButton.setIcon(new ImageIcon(url));
        url = this.getClass().getResource("/images/remove_disabled.png");
        this.removeButton.setDisabledIcon(new ImageIcon(url));
        this.removeButton.setToolTipText("\u524a\u9664");
        this.removeButton.setEnabled(false);
        this.configureButton = new JButton();
        this.configureButton.setFocusPainted(false);
        this.configureButton.setPreferredSize(new Dimension(30, 30));
        this.configureButton.setMinimumSize(new Dimension(30, 30));
        this.configureButton.setMaximumSize(new Dimension(30, 30));
        this.configureButton.addActionListener(new OnClickListener());
        url = this.getClass().getResource("/images/config.png");
        this.configureButton.setIcon(new ImageIcon(url));
        this.configureButton.setToolTipText("\u8a2d\u5b9a");
        toolbar.add(this.reloadButton);
        toolbar.addSeparator();
        toolbar.add(this.openButton);
        toolbar.add(this.removeButton);
        toolbar.addSeparator();
        toolbar.add(this.configureButton);
        this.getContentPane().add((Component)toolbar, "North");
    }

    private void initializeTable() {
        this.table = new TargetTable((TableModel)this.tableModel, this.targetLives, this);
        this.table.setAutoResizeMode(0);
        this.table.setDefaultEditor(Object.class, null);
        KeyStroke keystroke = KeyStroke.getKeyStroke(127, 0, false);
        this.table.registerKeyboardAction(this, keystroke, 2);
        this.table.addMouseListener(this);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(16);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(120);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(80);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(80);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(80);
        this.getContentPane().setDropTarget(new UrlDropTarget());
        this.getContentPane().add(new JScrollPane(this.table));
    }

    public static void main(String[] args) {
        new Manager("livepinger ver.0.0.7");
    }

    @Override
    public void onCrawlStart(ExtracterBase extracter) {
        int i = 0;
        while (i < this.targetLives.size()) {
            Live target = this.targetLives.get(i);
            if (target.getClass().equals(extracter.getLiveClass())) {
                this.tableModel.setValueAt("", i, 2);
                this.tableModel.setValueAt("", i, 3);
                this.tableModel.setValueAt("\u53d6\u5f97\u4e2d", i, 4);
                this.table.validate();
                this.table.repaint();
            }
            ++i;
        }
    }

    @Override
    public void onCrawlDone(ExtracterBase extracter, List<Live> lives) {
        int i = 0;
        while (i < this.targetLives.size()) {
            Live target = this.targetLives.get(i);
            if (target.getClass().equals(extracter.getLiveClass())) {
                Live foundLive = null;
                for (Live live : lives) {
                    if (!live.match(target)) continue;
                    foundLive = live;
                    foundLive.setOnair(target.isOnair());
                    this.targetLives.remove(i);
                    this.targetLives.add(i, live);
                    target = live;
                    break;
                }
                if (!target.isOnair() & foundLive != null) {
                    if (this.notifierIndex == 0) {
                        new SoundPlayer(SOUND_FILENAME).start();
                    }
                    new NotifierFrame(this.notifierIndex, target, this);
                    ++this.notifierIndex;
                }
                target.setOnair(foundLive != null);
            }
            ++i;
        }
        this.updateTableModel(extracter);
        try {
            TargetFile.save(this.targetLives);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void updateTableModel(ExtracterBase extracter) {
        int i = 0;
        while (i < this.targetLives.size()) {
            Live target = this.targetLives.get(i);
            if (target.getClass().equals(extracter.getLiveClass())) {
                String identifier = target.getDisplayIdentifier();
                this.tableModel.setValueAt(identifier, i, 1);
                String listener = target.getListener() == null ? "-" : target.getListener().toString();
                this.tableModel.setValueAt(listener, i, 2);
                String comment = target.getCommentCount() == null ? "-" : target.getCommentCount().toString();
                this.tableModel.setValueAt(comment, i, 3);
                String status = target.isOnair() ? "\u30aa\u30f3\u30a8\u30a2\u30fc" : "\u30aa\u30d5\u30e9\u30a4\u30f3";
                this.tableModel.setValueAt(status, i, 4);
                this.table.validate();
                this.table.repaint();
            }
            ++i;
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.removeSelectedRow();
    }

    public void removeSelectedRow() {
        int[] rows = this.table.getSelectedRows();
        int deleteCount = 0;
        int[] nArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            int row = nArray[n2];
            int index = row - deleteCount;
            this.tableModel.removeRow(index);
            this.targetLives.remove(index);
            ++deleteCount;
            ++n2;
        }
        try {
            TargetFile.save(this.targetLives);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void openSelectedRow() {
        int[] rows = this.table.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        int index = rows[0];
        if (index >= this.targetLives.size()) {
            return;
        }
        Live targetLive = this.targetLives.get(index);
        String url = targetLive.getUrl();
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.browse(new URI(url));
        }
        catch (IOException iOException) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (event.getClickCount() == 2) {
            Point pt = event.getPoint();
            int index = this.table.rowAtPoint(pt);
            if (index >= this.targetLives.size()) {
                return;
            }
            Live targetLive = this.targetLives.get(index);
            String url = targetLive.getUrl();
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(new URI(url));
            }
            catch (IOException iOException) {
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int[] rows = this.table.getSelectedRows();
        boolean selected = rows.length != 0;
        this.openButton.setEnabled(selected);
        this.removeButton.setEnabled(selected);
    }

    @Override
    public void onEndNotifier(int index) {
        if (this.notifierIndex <= index + 1) {
            this.notifierIndex = 0;
        }
    }

    class OnClickListener
    implements ActionListener {
        OnClickListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == Manager.this.reloadButton) {
                Manager.this.crawlManager.startCrawl();
            } else if (event.getSource() == Manager.this.openButton) {
                Manager.this.openSelectedRow();
            } else if (event.getSource() == Manager.this.removeButton) {
                Manager.this.removeSelectedRow();
            } else if (event.getSource() == Manager.this.configureButton) {
                new ConfigureFrame(Manager.this.getOwner(), Manager.this, "config livepinger");
            }
        }
    }

    class UrlDropTarget
    extends DropTarget
    implements Live.OnResolveLiveDoneListener {
        private static final long serialVersionUID = -6644498608082348354L;

        UrlDropTarget() {
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            event.acceptDrop(3);
            Transferable transData = event.getTransferable();
            try {
                String url = (String)transData.getTransferData(DataFlavor.stringFlavor);
                log.info("[urldrop] url: " + url);
                Live live = Live.resolveUrl(url, this);
                this.onResolveLiveDone(live);
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (UnsupportUrlException e) {
                ErrorDialog.show(Manager.this, e.getMessage());
                e.printStackTrace();
            }
        }

        @Override
        public void onResolveLiveDone(Live live) {
            if (live == null) {
                return;
            }
            for (Live target : Manager.this.targetLives) {
                if (!target.getClass().equals(live.getClass()) || !target.match(live)) continue;
                return;
            }
            Manager.this.targetLives.add(live);
            Manager.this.tableModel.addRow(new String[]{live.getServiceName(), live.getDisplayIdentifier()});
            try {
                TargetFile.save(Manager.this.targetLives);
            }
            catch (IOException e) {
                ErrorDialog.show(Manager.this, "\u901a\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            }
            Manager.this.crawlManager.startCrawl(live);
        }

        @Override
        public void onResolveLiveFailure(String error) {
            ErrorDialog.show(Manager.this, error);
        }
    }
}

