/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache.memcached;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import net.spy.memcached.CASResponse;
import net.spy.memcached.CASValue;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.MemcachedClientIF;
import net.spy.memcached.OperationTimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.cache.HttpCacheEntry;
import org.apache.http.client.cache.HttpCacheEntrySerializer;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.cache.HttpCacheUpdateCallback;
import org.apache.http.client.cache.HttpCacheUpdateException;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.DefaultHttpCacheEntrySerializer;
import org.apache.http.impl.client.cache.memcached.MemcachedOperationTimeoutException;

public class MemcachedHttpCacheStorage
implements HttpCacheStorage {
    private static final Log log = LogFactory.getLog(MemcachedHttpCacheStorage.class);
    private final MemcachedClientIF client;
    private final HttpCacheEntrySerializer serializer;
    private final int maxUpdateRetries;

    public MemcachedHttpCacheStorage(InetSocketAddress address) throws IOException {
        this((MemcachedClientIF)new MemcachedClient(new InetSocketAddress[]{address}));
    }

    public MemcachedHttpCacheStorage(MemcachedClientIF cache) {
        this(cache, new CacheConfig(), new DefaultHttpCacheEntrySerializer());
    }

    public MemcachedHttpCacheStorage(MemcachedClientIF client, CacheConfig config, HttpCacheEntrySerializer serializer) {
        this.client = client;
        this.maxUpdateRetries = config.getMaxUpdateRetries();
        this.serializer = serializer;
    }

    public void putEntry(String url, HttpCacheEntry entry) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.serializer.writeTo(entry, bos);
        try {
            this.client.set(url, 0, (Object)bos.toByteArray());
        }
        catch (OperationTimeoutException ex) {
            throw new MemcachedOperationTimeoutException(ex);
        }
        catch (IllegalArgumentException iae) {
            return;
        }
    }

    private byte[] convertToByteArray(Object o) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof byte[])) {
            log.warn("got a non-bytearray back from memcached: " + o);
            return null;
        }
        return (byte[])o;
    }

    private HttpCacheEntry reconstituteEntry(Object o) throws IOException {
        byte[] out = this.convertToByteArray(o);
        if (out == null) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(out);
        return this.serializer.readFrom(bis);
    }

    public HttpCacheEntry getEntry(String url) throws IOException {
        try {
            return this.reconstituteEntry(this.client.get(url));
        }
        catch (OperationTimeoutException ex) {
            throw new MemcachedOperationTimeoutException(ex);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    public void removeEntry(String url) throws IOException {
        try {
            this.client.delete(url);
        }
        catch (OperationTimeoutException ex) {
            throw new MemcachedOperationTimeoutException(ex);
        }
        catch (IllegalArgumentException iae) {
            return;
        }
    }

    public void updateEntry(String url, HttpCacheUpdateCallback callback) throws HttpCacheUpdateException, IOException {
        int numRetries = 0;
        do {
            try {
                CASValue v = this.client.gets(url);
                HttpCacheEntry existingEntry = v == null ? null : this.reconstituteEntry(v.getValue());
                HttpCacheEntry updatedEntry = callback.update(existingEntry);
                if (v == null) {
                    this.putEntry(url, updatedEntry);
                    return;
                }
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                this.serializer.writeTo(updatedEntry, bos);
                CASResponse casResult = this.client.cas(url, v.getCas(), (Object)bos.toByteArray());
                if (casResult == CASResponse.OK) {
                    return;
                }
            }
            catch (OperationTimeoutException ex) {
                throw new MemcachedOperationTimeoutException(ex);
            }
            catch (IllegalArgumentException iae) {
                throw new HttpCacheUpdateException("url exceeds max key length for memcached");
            }
        } while (++numRetries <= this.maxUpdateRetries);
        throw new HttpCacheUpdateException("Failed to update");
    }
}

