/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.livepinger.crawler;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.livepinger.crawler.Crawler;
import net.sourceforge.livepinger.dto.Live;

public class CrawlManager {
    List<Crawler> crawlers = new ArrayList<Crawler>();

    public void register(Crawler crawler) {
        this.crawlers.add(crawler);
    }

    public void start() {
        for (Crawler crawler : this.crawlers) {
            crawler.start();
        }
    }

    public void startCrawl() {
        for (Crawler crawler : this.crawlers) {
            crawler.startCrawl();
        }
    }

    public void startCrawl(Live live) {
        for (Crawler crawler : this.crawlers) {
            if (!live.getClass().equals(crawler.getExtracter().getLiveClass())) continue;
            crawler.startCrawl();
        }
    }

    public void stopCrawl() {
        for (Crawler crawler : this.crawlers) {
            crawler.stopCrawl();
        }
    }

    public void setInterval(long interval) {
        for (Crawler crawler : this.crawlers) {
            crawler.setInterval(interval);
        }
    }
}

