/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.livepinger.dto;

import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.livepinger.crawler.RequestRunner;
import net.sourceforge.livepinger.dto.Live;

public class CavetubeLive
extends Live
implements RequestRunner.OnRequestDoneListener {
    public static String SERVICE_NAME = "C";
    public static String BASE_URL = "http://gae.cavelis.net/";
    private static final String BACKGROUND_IMAGE_PATH = "/images/notifier_bg_cavetube.png";
    private static Image backgroundImage = null;
    static Pattern URL_PATTERN = Pattern.compile("http://gae\\.cavelis\\.net/view/[0-9A-F]+");
    static Pattern LIVENAME_PATTERN = Pattern.compile("<title>(.*?) : CaveTube</title>");
    static Pattern IDENTIFIER_PATTERN = Pattern.compile("<a href=\"/user/([^\"]+)\" class=\"author_image\">");
    Live.OnResolveLiveDoneListener onResolveLiveDoneListener;

    public CavetubeLive(String url, String identifier, String livename) {
        super(url, identifier, livename);
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public synchronized Image getBackgroundImageInstance() {
        if (backgroundImage == null) {
            URL url = CavetubeLive.class.getResource(BACKGROUND_IMAGE_PATH);
            backgroundImage = Toolkit.getDefaultToolkit().getImage(url);
        }
        return backgroundImage;
    }

    public void crawlLivepage(Live.OnResolveLiveDoneListener onResolveLiveDoneListener) {
        this.onResolveLiveDoneListener = onResolveLiveDoneListener;
        RequestRunner runner = new RequestRunner(this.getUrl(), this);
        runner.start();
    }

    @Override
    public void onRequestDone(RequestRunner runner, String data) {
        Matcher identifierMatcher;
        Matcher livenameMatcher = LIVENAME_PATTERN.matcher(data);
        if (livenameMatcher.find()) {
            this.setName(livenameMatcher.group(1));
        }
        if ((identifierMatcher = IDENTIFIER_PATTERN.matcher(data)).find()) {
            this.setIdentifier(identifierMatcher.group(1));
        }
        if (this.onResolveLiveDoneListener != null) {
            this.onResolveLiveDoneListener.onResolveLiveDone(this);
        }
    }

    public static boolean match(String url) {
        return URL_PATTERN.matcher(url).matches();
    }
}

