/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.livepinger.dto;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.livepinger.dto.Live;

public class UstreamLive
extends Live {
    public static String SERVICE_NAME = "U";
    public static String BASE_URL = "http://www.ustream.tv/";
    static Pattern URL_PATTERN = Pattern.compile("http://www.ustream.tv/channel/([^/]+)");
    static Pattern IDENTIFIER_PATTERN = Pattern.compile("/([^/]+)$");
    private static final String BACKGROUND_IMAGE_PATH = "/images/notifier_bg_ustream.png";
    private static Image backgroundImage = null;

    public UstreamLive(String url, String identifier, String livename) {
        super(url, identifier, livename);
    }

    public static String getIdentifierFromUrl(String url) {
        Matcher matcher = IDENTIFIER_PATTERN.matcher(url);
        if (matcher.find() && matcher.groupCount() > 0) {
            try {
                return URLDecoder.decode(matcher.group(1), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public Image getBackgroundImageInstance() {
        if (backgroundImage == null) {
            URL url = this.getClass().getResource(BACKGROUND_IMAGE_PATH);
            backgroundImage = Toolkit.getDefaultToolkit().getImage(url);
        }
        return backgroundImage;
    }

    public static boolean match(String url) {
        return URL_PATTERN.matcher(url).matches();
    }
}

