/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.livepinger.extracter;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.livepinger.crawler.CrawlException;
import net.sourceforge.livepinger.crawler.OnCrawlDoneListener;
import net.sourceforge.livepinger.crawler.RequestRunner;
import net.sourceforge.livepinger.dto.Live;

public abstract class ExtracterBase {
    public abstract List<Live> extract(String var1, String var2);

    public abstract String getCrawlUrl();

    public abstract Class getLiveClass();

    public void crawl(List<Live> targetLives, OnCrawlDoneListener crawlDoneListener) {
        if (!this.isRequireCrawl(targetLives)) {
            if (crawlDoneListener != null) {
                crawlDoneListener.onCrawlDone(this, new ArrayList<Live>());
            }
            return;
        }
        try {
            RequestRunner runner = new RequestRunner(this.getCrawlUrl());
            String data = runner.getSimplePage();
            ArrayList<Live> lives = new ArrayList<Live>();
            lives.addAll(this.extract(this.getCrawlUrl(), data));
            if (crawlDoneListener != null) {
                crawlDoneListener.onCrawlDone(this, lives);
            }
        }
        catch (CrawlException e) {
            e.printStackTrace();
        }
    }

    public boolean isRequireCrawl(List<Live> targetLives) {
        boolean found = false;
        for (Live target : targetLives) {
            if (!target.getClass().equals(this.getLiveClass())) continue;
            found = true;
            break;
        }
        return found;
    }

    public List<Live> collectMatchLives(List<Live> lives) {
        ArrayList<Live> matchLives = new ArrayList<Live>();
        for (Live live : lives) {
            if (!live.getClass().equals(this.getLiveClass())) continue;
            matchLives.add(live);
        }
        return matchLives;
    }
}

