/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.livepinger.manager;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sourceforge.livepinger.manager.Configuration;
import net.sourceforge.livepinger.manager.ConfigurationFile;
import net.sourceforge.livepinger.manager.ValidationException;

public class ConfigureFrame
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 4742786725318643353L;
    JTextField popupLifeTimeTextField;
    JButton commitButton;
    JButton cancelButton;

    public JTextField getPopupLifeTimeTextField() {
        return this.popupLifeTimeTextField;
    }

    public void setPopupLifeTimeTextField(JTextField popupLifeTimeTextField) {
        this.popupLifeTimeTextField = popupLifeTimeTextField;
    }

    public ConfigureFrame(Window owner, JFrame parent, String title) throws HeadlessException {
        super(owner, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.initializeFrame();
        this.initializeComponent();
        this.initializeConfiguration();
        this.setBounds(parent.getX(), parent.getY(), this.getWidth(), this.getHeight());
        this.setVisible(true);
    }

    private void initializeConfiguration() {
        Configuration config = Configuration.getInstance();
        this.popupLifeTimeTextField.setText(String.valueOf(config.getPopupLifeTime()));
    }

    private void initializeComponent() {
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JLabel popupLifetimeLable = new JLabel("\u30dd\u30c3\u30d7\u30a2\u30c3\u30d7\u8868\u793a\u6642\u9593");
        this.popupLifeTimeTextField = new JTextField();
        this.popupLifeTimeTextField.setColumns(4);
        this.popupLifeTimeTextField.setHorizontalAlignment(4);
        JLabel popupLifetimePrefixLable = new JLabel("\u79d2");
        JPanel popupPanel = new JPanel();
        popupPanel.setLayout(new FlowLayout(0));
        popupPanel.add(popupLifetimeLable);
        popupPanel.add(this.popupLifeTimeTextField);
        popupPanel.add(popupLifetimePrefixLable);
        popupPanel.setPreferredSize(new Dimension(Integer.MAX_VALUE, 40));
        this.add(popupPanel);
        this.commitButton = new JButton("\u9069\u7528");
        this.commitButton.setSize(60, 30);
        this.commitButton.addActionListener(this);
        this.cancelButton = new JButton("\u30ad\u30e3\u30f3\u30bb\u30eb");
        this.cancelButton.setSize(60, 30);
        this.cancelButton.addActionListener(this);
        JPanel commitPanel = new JPanel();
        commitPanel.setLayout(new FlowLayout(2));
        commitPanel.add(this.commitButton);
        commitPanel.add(this.cancelButton);
        commitPanel.setPreferredSize(new Dimension(Integer.MAX_VALUE, 40));
        this.add(commitPanel);
    }

    private void initializeFrame() {
        this.setSize(400, 100);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        URL url = this.getClass().getResource("/images/icon.png");
        this.setIconImage(Toolkit.getDefaultToolkit().createImage(url));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.commitButton) {
            try {
                Configuration config = Configuration.getInstance();
                config.applyFrame(this);
                ConfigurationFile.save(config);
                this.dispose();
            }
            catch (IOException e) {
                this.dispose();
            }
            catch (ValidationException validationException) {}
        } else if (event.getSource() == this.cancelButton) {
            this.dispose();
        }
    }
}

