/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.m4hv.extensions.util;

public final class Condition {

    private Condition() {
    }

    /**
     * Returns true if the value passed as the first parameter is less than the
     * value passed as the second parameter otherwise return false.
     *
     * @param arg1
     *            compared value
     * @param arg2
     *            compared value
     * @return true or false.
     */
    public static boolean isLessThan(int arg1, int arg2) {
        if (arg1 < arg2) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * Checks if given value by the first parameter is between the values passed
     * as the second and third parameters.
     *
     * @param value
     *            checked value.
     * @param from
     *            min of range.
     * @param until
     *            max of range.
     * @return value
     */
    public static Integer checkIncludedCorrectRange(int value, int from,
            int until) {
        if (from <= value && value <= until) {
            return value;
        }
        throw new IllegalArgumentException("The " + value
                + " must be included between " + from + " and " + until);
    }

    /**
     * Returns true if the value passed as the first parameter is between values
     * passed as the second and third parameters otherwise false.
     *
     * @param value
     *            checked value
     * @param from
     *            min of range
     * @param until
     *            max of range
     * @return true or false.
     */
    public static boolean isIncludedInRange(int value, int from, int until) {
        if (from <= value && value <= until) {
            return true;
        } else {
            return false;
        }
    }
}
