/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.m4hv.extensions.util;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class DateUtil {

    private DateUtil(){}

    public static Date canonicalize(String value, String[] patterns, String message) {
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.setLenient(false);

        ParsePosition pos = new ParsePosition(0);

        for (String pattern : patterns) {
            sdf.applyPattern(pattern);

            pos.setIndex(0);

            Date date = sdf.parse(value, pos);

            if (date != null && pos.getIndex() == value.length()) {
                return date;
            }

        }
        throw new IllegalArgumentException(message + value);
    }

}
