///////////////////////////////////////////////////////////////////////////////
//
// Frostice Core for Common Archiver Library v2.x source code.
//
///////////////////////////////////////////////////////////////////////////////
// FD_ARDLL.CPP = Frostice Doit group / for common ARchiver Library DLL func.
///////////////////////////////////////////////////////////////////////////////

#include "..\mxd_frtc.h"
#include "..\dlg\resource.h"

//-----------------------------------------------------------------------------
// for Common Archiver Project DLL settings...

HINSTANCE  hInstDll[SUPPORT_DLL_NUM+1];

#define		APISTR_MAXLEN	32
//dll chk...
static char dllname[SUPPORT_DLL_NUM+1][16] = 
{	"",
	"UNLHA32.DLL",
	"ZIP32J.DLL",
	"7-ZIP32.DLL",
	"CAB32.DLL",
	"TAR32.DLL",
	"TAR32.DLL",
	"TAR32.DLL",
	"BGA32.DLL",
	"BGA32.DLL",
	"YZ1.DLL"
};

static char getver_api[SUPPORT_DLL_NUM+1][APISTR_MAXLEN] = 
{
	"",
	"UnlhaGetVersion",
	"ZipGetVersion",
	"SevenZipGetVersion",
	"CabGetVersion",
	"TarGetVersion",
	"TarGetVersion",
	"TarGetVersion",
	"BgaGetVersion",
	"BgaGetVersion",
	"Yz1GetVersion"
};

// processing...
static char arcrun_api[SUPPORT_DLL_NUM+1][APISTR_MAXLEN] = 
{
	"",
	"Unlha",
	"Zip",
	"SevenZip",
	"Cab",
	"Tar",
	"Tar",
	"Tar",
	"Bga",
	"Bga",
	"Yz1"
};

//command for Compress to DOS8.3 name 
static char arcrun_dosname_cmd[SUPPORT_DLL_NUM+1][16] = {
	"",
	" -ji1 -h1 -i0 ",	//UNLHA32	: -ji0 = LFN, -ji1 = DOS name. / -h1 = HeaderLv1 + -i0 = FileName.ext=>FILENAME.EXT (v2.23.1+)
	" -k ",		//ZIP32J	: (no opt) = LFN, -k = DOS name.
	"",			//7-ZIP32
	" -q ",		//CAB32	: (no opt) = LFN, -q = DOS name.
	"",			//tar.gz  not supported.
	"", 		//tar.bz2 not supported.
	"", 		//tar.xz not supported.
	"",			//BGA32 not supported.
	"",			//BGA32 not supported.
	""			//YZ1 not supported.
};

//DLL compress command.
static char arcrun_pack_cmd[SUPPORT_DLL_NUM+1][24] = {
	"",
	"a -x1 -r2 -a2 -jso1",
	"-S -r",
	"a -t7z", //7-Zip
	"-a -r",
	"-c -z", //TAR32  -z1 ... -z9 -> Pack Level (Default:6).
	"-c -B", //TAR32  -B1 ... -B9 -> Pack Level (Default:9).
	"-c -J", //TAR32  -J1 ... -J9 -> Pack Level (Default:6).
	"a -m1 -a -r",
	"a -m2 -a -r",
	"c -y "
};

//DLL archive file to exe(SFX) command.
static char arcrun_sfx_cmd[SUPPORT_DLL_NUM+1][36] = {
	"",
	"s -gwe3 -x1 -r2 -a2 -jso1 -jsz1 ",	//UNLHA32 : gw3 = CfgDialog and toWinSFX32M. -gw[e|j] = en or jp. -jsz1 = ".exe" lower char.
	"--sfx ",	//this option have to need sfx32gui.dat for ZIP32J.DLL
	"-sfx ",		//7-Zip
	"-f -i ",	// -f = makeSFX, i=Silent mode.
	"",			// ---v--- TAR32.DLL can't support SFX.
	"",			// --- --- TAR32.DLL can't support SFX.
	"",			// ---^--- TAR32.DLL can't support SFX.
	"s ",
	"s ",
	"s "		//YZ1 SFX have to need yzdec.exe.
	
};

//DLL archive file with password command. (for zip,yz1)
static char arcrun_pwd_cmd[SUPPORT_DLL_NUM+1][4] = {
	"",
	"",		// lzh cannot support password.
	" -e",
	" -p",
	"",		// cab cannot support password.
	"",		// tar cannot support password.
	"",
	"",
	"",		// bga cannot support password.
	"",
	" -p"
	
};

//PackLevel.
static char arcrun_pack_with_level[SUPPORT_DLL_NUM+1][8] = {
	"",
	" -jm",		//UNLHA32	: (-jm0=lh0,) -jm1=lh1, -jm2=lh5 (Default), -jm3=lh6, -jm4=lh7, -jma=lhx-auto.
	" -",		//ZIP32J	: (-0 = Lvl0,) -1 = Level 1 ... -9 = Level 9.
	" -mx=",	//7-ZIP32	: (-mx=0 = Lvl0,) -mx=1 = Level 1 ... -mx=9 = Level 9. (Level 0 1 5 7 9)
	" -ml:",	//CAB32		: (-ms = nocompress, -mz = mszip), -ml:15 = LZX/15 ... -ml:21 = LZX/21
	"", 		//TAR32		: -z1 = Level 1 ... -z9 = Level 9. (gz)
	"", 		//TAR32		: -B1 = Level 1 ... -B9 = Level 9. (bz2)
	"", 		//TAR32		: -J1 = Level 1 ... -J9 = Level 9. (xz)
	" -l",		//BGA32		: -l1 = Level 1 ... -l9 = Level 9. (Level 9 Default.)
	" -l",		//BGA32		: -l1 = Level 1 ... -l9 = Level 9. (Level 9 Default.)
	""  		//YZ1		: the YZ1 format has no level.
};


static char dllerr_msg[80][24] = {
	"ERROR_START", //0x8000
	"", //0x8001
	"", //0x8002
	"", //0x8003
	"", //0x8004
	"ERROR_DISK_SPACE",			//0x8005
	"ERROR_READ_ONLY",			//0x8006
	"ERROR_USER_SKIP",			//0x8007
	"ERROR_UNKNOWN_TYPE",		//0x8008
	"ERROR_METHOD",				//0x8009
	"ERROR_PASSWORD_FILE2",		//0x800A
	"ERROR_VERSION",			//0x800B
	"ERROR_FILE_CRC",			//0x800C
	"ERROR_FILE_OPEN",			//0x800D
	"ERROR_MORE_FRESH",			//0x800E
	"ERROR_NOT_EXIST",			//0x800F
	"ERROR_ALREADY_EXIST",		//0x8010
	"ERROR_TOO_MANY_FILES",		//0x8011
	"ERROR_MAKEDIRECTORY",		//0x8012
	"ERROR_CANNOT_WRITE",		//0x8013
	"ERROR_HUFFMAN_CODE",		//0x8014
	"ERROR_COMMENT_HEADER",		//0x8015
	"ERROR_HEADR_CRC",			//0x8016
	"ERROR_HEADER_BROKEN",		//0x8017
	"ERROR_ARC_FILE_OPEN",		//0x8018
	"ERROR_NOT_ARC_FILE",		//0x8019
	"ERROR_CANNOT_READ",		//0x801A
	"ERROR_FILE_STYLE",			//0x801B
	"ERROR_COMMAND_NAME",		//0x801C
	"ERROR_MORE_HEAP_MEMORY",	//0x801D
	"ERROR_ENOUGH_MEMORY",		//0x801E
	"ERROR_ALREADY_RUNNING",	//0x801F
	"ERROR_USER_CANCEL",		//0x8020
	"ERROR_HARC_ISNOT_OPENED",	//0x8021
	"ERROR_NOT_SEARCH_MODE",	//0x8022
	"ERROR_NOT_SUPPORT",		//0x8023
	"ERROR_TIME_STAMP",			//0x8024
	"ERROR_TMP_OPEN",			//0x8025
	"ERROR_LONG_FILE_NAME",		//0x8026
	"ERROR_ARC_READ_ONLY",		//0x8027
	"ERROR_SAME_NAME_FILE",		//0x8028
	"ERROR_NOT_FIND_ARC_FILE",	//0x8029
	"ERROR_RESPONSE_READ",		//0x802A
	"ERROR_NOT_FILENAME",		//0x802B
	"ERROR_TMP_COPY",			//0x802C
	"ERROR_EOF",				//0x802D
	"ERROR_ADD_TO_LARC",		//0x802E
	"ERROR_TMP_BACK_SPACE",		//0x802F
	"ERROR_SHARING",			//0x8030
	"ERROR_NOT_FIND_FILE",		//0x8031
	"ERROR_LOG_FILE",			//0x8032
	"ERROR_NO_DEVICE",			//0x8033
	"ERROR_GET_ATTRIBUTES",		//0x8034
	"ERROR_SET_ATTRIBUTES",		//0x8035
	"ERROR_GET_INFORMATION",	//0x8036
	"ERROR_GET_POINT",			//0x8037
	"ERROR_SET_POINT",			//0x8038
	"ERROR_CONVERT_TIME",		//0x8039
	"ERROR_GET_TIME",			//0x803a
	"ERROR_SET_TIME",			//0x803b
	"ERROR_CLOSE_FILE",			//0x803c
	"ERROR_HEAP_MEMORY",		//0x803d
	"ERROR_HANDLE",				//0x803e
	"ERROR_TIME_STAMP_RANGE",	//0x803f
	"ERROR_MAKE_ARCHIVE",		//0x8040
	"ERROR_NOT_CONFIRM_NAME",   //0x8041
	"ERROR_UNEXPECTED_EOF",		//0x8042
	"ERROR_INVALID_END_MARK",	//0x8043
	"ERROR_INVOLVED_LZH",		//0x8044
	"ERROR_NO_END_MARK",		//0x8045
	"ERROR_HDR_INVALID_SIZE",	//0x8046
	"ERROR_UNKNOWN_LEVEL",		//0x8047
	"ERROR_BROKEN_DATA",		//0x8048
	"ERROR_INVALID_PATH",		//0x8049
	"ERROR_TOO_BIG",			//0x804a
	"ERROR_EXECUTABLE_FILE",	//0x804b
	"ERROR_INVALID_VALUE",		//0x804c
	"ERROR_HDR_EXPLOIT",		//0x804d
	"ERROR_HDR_NO_CRC",			//0x804e
	"ERROR_HDR_NO_NAME"			//0x804f
};

void get_dllerr_msg(char *errmsg,int errcode)
{
	if(errcode >= 0x8000 && errcode <= 0x804f)
		lstrcpyn(errmsg,dllerr_msg[errcode-0x8000],64);
	else
		lstrcpyn(errmsg,"UNKNOWN",64);
}


//Get DLL CompressLevel Command.
static void get_levelcmd(char *cmd, const int level, const int mode)
{
	switch(mode)
	{
		// (arcrun_pack_with_level) + (1...9 number.)
		case MODE_ZIP: //ZIP
			if(level>=1)
			{
				wsprintf(cmd,"%s%d ",arcrun_pack_with_level[mode],level);
			}
			else if(level==-1)
			{
				wsprintf(cmd,"%s%d ",arcrun_pack_with_level[mode],0);
			}
			break;
		case MODE_TGZ: //TAR (gzip)
		case MODE_TBZ: //TAR (bzip2)
		case MODE_GZA: //BGA (gzip)
		case MODE_BZA: //BGA (bzip2)
			wsprintf(cmd,"%s%d ",arcrun_pack_with_level[mode],level);
			break;
		case MODE_LZH: //LHa
			if      (level ==-1) wsprintf(cmd,"%s%d ",arcrun_pack_with_level[mode],0); // level 0 = lh0. (-jm0)
			else if (level == 1) wsprintf(cmd,"%s%d ",arcrun_pack_with_level[mode],1); // level 1 = lh1. (-jm1)
			else if (level >= 2 && level <= 4) wsprintf(cmd,"%s%d ",arcrun_pack_with_level[mode],2); // level 2,3,4 = lh5. (-jm2)
			else if (level >= 8) wsprintf(cmd,"%sa ",arcrun_pack_with_level[mode]); // level 8,9 = lhx (Auto).
			else wsprintf(cmd,"%s%d ",arcrun_pack_with_level[mode],level-3); // level 5,6,7 = lh5,6,7. (lh1=no support.) (-jm2,3,4)
			break;
		case MODE_7Z:  //7Zip
			if     (level ==-1) wsprintf(cmd,"%s%d ",arcrun_pack_with_level[mode],0);	// level 0
			else if(level == 1) wsprintf(cmd,"%s%d ",arcrun_pack_with_level[mode],1);	// level 1
			else if(level <= 5) wsprintf(cmd,"%s%d ",arcrun_pack_with_level[mode],5);	// level 2,3,4,5 = level 5
			else if(level <= 7) wsprintf(cmd,"%s%d ",arcrun_pack_with_level[mode],7);	// level 6,7     = level 7
			else if(level >  7) wsprintf(cmd,"%s%d ",arcrun_pack_with_level[mode],9);	// level 8,9     = level 9
			break;
		case MODE_CAB: //Cab
			if     (level==-1)lstrcpy(cmd, " -ms"); //mszip.
			else if(level==1) lstrcpy(cmd, " -mz"); //mszip.
			else if(level>=2 && level<=8) wsprintf(cmd,"%s%d ",arcrun_pack_with_level[mode],level+13); // level 2=LZX/15...level 8=LZX/21
			else wsprintf(cmd,"%s%d ",arcrun_pack_with_level[mode],21); // level 9=LZX/21
			break;
		//none. (etc...)
		case MODE_YZ1: //YZ1
		default:
			lstrcpy(cmd,"");
			break;
		
	}
}

// load Common Archiver's Project DLL
//   return true  -> DLL load success!
//   return false -> DLL load failed.
static bool load_dll(int mode)
{
	if(mode == 0) return false;
//	if(get_noardll(0) == true) return false;

	hInstDll[mode] =  LoadLibrary( dllname[mode] );
	if(hInstDll[mode] == NULL) return false;
	return true;
}

// make SFX file from archive file.
static void arc2sfx
	(	const HWND hDlg,
		const char *packedfile,	//packedfile. (packfullpath.)
		const char *outputdir,	//outputdir
		int mode)				//mode/
{
	if( !(	mode == MODE_LZH ||	//lzh
			mode == MODE_ZIP ||	//zip
			mode == MODE_CAB ||	//cab
			mode == MODE_GZA ||	//gza
			mode == MODE_BZA ||	//bza
			mode == MODE_YZ1	//yz1
			) ) return; //Frostice can support lzh,zip,cab,gza,bza,yz1s' SFX.
	typedef BOOL  (WINAPI *PARCRUNFUNC)(const HWND, LPCSTR,LPSTR, const DWORD);
	
	if( load_dll(mode) == true){
		PARCRUNFUNC ArcRun = (PARCRUNFUNC)GetProcAddress(hInstDll[mode], arcrun_api[mode]);
		if(ArcRun != NULL) // API function ready...
		{
			char cmdbuf[MAX_PATH * 4];
			wsprintf(cmdbuf,"%s %s %s",arcrun_sfx_cmd[mode], packedfile, outputdir);
			int ret = (*ArcRun)(hDlg,cmdbuf,NULL,0);
			if(get_writelog()==true)
			{
				char *logbuf = new char[MAX_PATH * 5];
				char *errormsg = new char[32]; get_dllerr_msg(errormsg,ret);

				wsprintf(logbuf, "%s : [%s cmd] <%s>",packedfile, dllname[mode], cmdbuf);
				output_log("FROSTICE.LOG",logbuf);

				if(ret == 0)
					wsprintf(logbuf, "%s : [OK] (Arc2Sfx) Frostice succeeded in processing of this file.",packedfile);
				else
					wsprintf(logbuf, "%s : [NG] (Arc2Sfx) Frostice failed in processing of this file. (0x%04x:%s)",packedfile,ret,errormsg);
				output_log("FROSTICE.LOG",logbuf);
				delete [] errormsg;
				delete [] logbuf;
			}
		}
	}
	return;
}

// make JACK file from archive file when archive file's filesize is 1423KB over
// and exist JACK32.DLL and Not create SFX File.
//(it is bonus function(as Japanese, "omake") :-)
static void arc2jak
	(	const HWND hDlg,
		const char *packedfile,	//packedfile. (packfullpath.)
		const char *outputdir)	//outputdir
{
	if( get_withsfx() == true ) return; // not supported SFX divide.
	
	HINSTANCE  hInstJakDll;
	typedef DWORD  (WINAPI *PJAKRUNFUNC)(LPCSTR,LPCSTR,int,LPCSTR);

	hInstJakDll =  LoadLibrary("JACK32.DLL");
	if(hInstJakDll == NULL) return;
	PJAKRUNFUNC JakRun = (PJAKRUNFUNC)GetProcAddress(hInstJakDll, "JackRipper");
	if(JakRun == NULL) return; // API function not ready...

	DWORD dwSize;
	HANDLE hPkFile = CreateFile(packedfile, GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if(hPkFile == INVALID_HANDLE_VALUE )
		return ;
	//GetFileSize (0 bytes - 4GB only.)
	dwSize = GetFileSize(hPkFile,NULL);
	if (dwSize == 0xFFFFFFFF)
	{
		CloseHandle(hPkFile);
		return ; //4GB over or other error.
	}
	CloseHandle(hPkFile);
	
	if(dwSize > 1423*1024) //over 1.38MB 2HD Disksize.
	{
		int ret;
		
		char *str_isjack_msg   = new char[1024];
		char *str_isjack_title = new char[128];
		if(get_autolang() == true && GetACP() == IDS_STR_JPN_CODEPAGE) //AutoLang == true and Japanese env.
		{
			LoadString(get_dll_instance(),IDS_STR_ISJACKDIV      +IDS_STR_ADD_FORJPN,str_isjack_msg,1023);
			LoadString(get_dll_instance(),IDS_STR_ISJACKDIV_TITLE+IDS_STR_ADD_FORJPN,str_isjack_title,127);
		}else{
			LoadString(get_dll_instance(),IDS_STR_ISJACKDIV      ,str_isjack_msg,1024);
			LoadString(get_dll_instance(),IDS_STR_ISJACKDIV_TITLE,str_isjack_title,128);
		}
		ret = MessageBox(hDlg,str_isjack_msg,str_isjack_title,MB_ICONQUESTION|MB_YESNOCANCEL|MB_TOPMOST);
		delete [] str_isjack_title;
		delete [] str_isjack_msg;

		switch(ret)
		{
			case IDYES:
				(*JakRun)(packedfile,outputdir,1,"1423");
				break;
			case IDNO:
				break; // no divide and no setting change.
			default:
				inicfg_to_memcfg();  //setting reset.
				set_withjak(false); //User don't want to Jak divide now, and future.
				memcfg_to_inicfg(NULL); // withjak=false saving...
				break;
		}
	}
}

// pack and compress file from data file.
//  hDlg      <- hWnd.
//  newpkfile <- new archive file name.
//  filenames <- Filenames for Pack. (String ->["file1.txt" "file2.txt" ...] )
//  basedir   <- Base Dir.
//  outputdir <- destdir
//  mode      <- Pack mode. (lzh,zip,...)
int ardll_frost
	(	const HWND hDlg,
		const char *newpkfile,
		const char *filenames,
		const char *basedir,
		const char *outputdir,
		int mode)
{
	int ret;
	typedef BOOL  (WINAPI *PARCRUNFUNC)(const HWND, LPCSTR,LPSTR, const DWORD);
	
	if( load_dll(mode) == true){
		PARCRUNFUNC ArcRun = (PARCRUNFUNC)GetProcAddress(hInstDll[mode], arcrun_api[mode]);
		if(ArcRun != NULL) // API function ready...
		{
			char *cmdbuf= new char[(lstrlen(filenames)+(MAX_PATH*4))*2];
			char packfullpath[MAX_PATH];
			char packdirpath[MAX_PATH];


			lstrcpyn(packfullpath,outputdir,lstrlen(outputdir)-1);
			path_add_backslash(packfullpath);
			lstrcat(packfullpath,newpkfile);
			lstrcat(packfullpath,"\"");

			char *subcmd = new char[MAX_PATH]; char *cbuf = new char[MAX_PATH]; //Temp buffer create.
			lstrcpy(subcmd,"");
			
			//Pack Level Settings.
			if(get_packlvl() != 0)
			{
				get_levelcmd(cbuf, get_packlvl(), mode);
				lstrcat(subcmd,cbuf);
			}
			if(get_dosname() == true)
			{
				lstrcat(subcmd, arcrun_dosname_cmd[mode]);
			}

			if(get_withsfx() == true && mode == MODE_7Z)
			{
				lstrcat(subcmd, " ");
				lstrcat(subcmd, arcrun_sfx_cmd[mode]);
			}
			else if(get_withpwd() == true)
			{
				lstrcat(subcmd, arcrun_pwd_cmd[mode]);
			}
			
/*			//wsprintf max buf is 2048... :-(
			wsprintf(cmdbuf,"%s%s %s %s %s",
				arcrun_pack_cmd[mode],subcmd,
				packfullpath, basedir, filenames);
*/
			lstrcpy(cmdbuf,arcrun_pack_cmd[mode]);
			lstrcat(cmdbuf,subcmd);lstrcat(cmdbuf," ");
			lstrcat(cmdbuf,packfullpath);lstrcat(cmdbuf," ");
			lstrcat(cmdbuf,basedir);lstrcat(cmdbuf," ");


			char *filenames_buf = new char[strlen(filenames)+1];
			char *for_anti_minus = filenames_buf;
			lstrcpy(for_anti_minus, filenames);

			bool dq_flag = false;
			int filename_char_count = 0;
			while(*for_anti_minus)
			{
				if(*for_anti_minus == '\"')
				{
					dq_flag = !dq_flag;
					if(dq_flag==true)
					{
						filename_char_count=0;
					}
				}
				else if(
					(*for_anti_minus == '-'  || *for_anti_minus == '@') // for anti minus = '-' or '@' by Ver.2.2.1~ (Escape response file)
					&& filename_char_count == 1)
				{
					// ".\" add...
					lstrcat(cmdbuf,".\\");
				}

				//1char add...
				{
					char anti_minus_buf[8];
					wsprintf(anti_minus_buf, "%c", *for_anti_minus);
					lstrcat(cmdbuf,anti_minus_buf);
				}
				
				filename_char_count++;
				for_anti_minus++;
			}

 			delete [] filenames_buf;
			delete [] subcmd;
			delete [] cbuf;

			ret = (*ArcRun)(hDlg,cmdbuf,NULL,0);
			if(get_writelog()==true)
			{
				char *logbuf = new char[(lstrlen(filenames) + MAX_PATH*2)*2];
				char *errormsg = new char[32]; get_dllerr_msg(errormsg,ret);

				wsprintf(logbuf, "\r\n%s : [Base folder] %s",packfullpath, basedir);
				output_log("FROSTICE.LOG",logbuf);
				wsprintf(logbuf, "%s : [The files which you want to compress.] ",packfullpath);
				lstrcat(logbuf,filenames);
				output_log("FROSTICE.LOG",logbuf);

				wsprintf(logbuf, "%s : [%s cmd] <",packfullpath, dllname[mode]);
				lstrcat(logbuf,cmdbuf); lstrcat(logbuf,">");

				output_log("FROSTICE.LOG",logbuf);

				if(ret == 0)
					wsprintf(logbuf, "%s : [OK] Frostice succeeded in processing of this file.",packfullpath);
				else
					wsprintf(logbuf, "%s : [NG] Frostice failed in processing of this file. (0x%04x:%s)",packfullpath,ret,errormsg);
				output_log("FROSTICE.LOG",logbuf);
				delete [] errormsg;
				delete [] logbuf;
			}

			if(ret==0){

				//make sfx files for lzh,zip,cab.
				if(get_withsfx() == true) arc2sfx(hDlg,packfullpath,outputdir,mode);
				
				//make MD5 hash. (archive file only), can't SFX's MD5 hash.
				if(get_withsfx() != true && get_withmd5()==true){
					lstrcpyn(packfullpath,outputdir+1,lstrlen(outputdir)-2);
					lstrcat(packfullpath,newpkfile);
					md5_hash_byfile(packfullpath,get_md5form());
				}

				if(get_withsfx() != true &&  get_withjak() == true )
				{ 
					lstrcpyn(packdirpath ,outputdir+1,lstrlen(outputdir)-2);
					lstrcpyn(packfullpath,outputdir+1,lstrlen(outputdir)-2);
					lstrcat(packfullpath,newpkfile);
					arc2jak(hDlg,packfullpath,packdirpath);
				}
			}
			delete [] cmdbuf;
			return ret;
		}
	}else{
		char *str_nodll_msg   = new char[1024];
		char *str_nodll_title = new char[128];
		char *msgbuf          = new char[1024];
		if(get_autolang() == true && GetACP() == IDS_STR_JPN_CODEPAGE) //AutoLang == true and Japanese env.
		{
			LoadString(get_dll_instance(),IDS_STR_ERR_NODLL      +IDS_STR_ADD_FORJPN,str_nodll_msg,1023);
			LoadString(get_dll_instance(),IDS_STR_ERR_NODLL_TITLE+IDS_STR_ADD_FORJPN,str_nodll_title,127);
		}else{
			LoadString(get_dll_instance(),IDS_STR_ERR_NODLL      ,str_nodll_msg,1024);
			LoadString(get_dll_instance(),IDS_STR_ERR_NODLL_TITLE,str_nodll_title,128);
		}

		wsprintf(msgbuf, str_nodll_msg, dllname[mode]);
		MessageBox(hDlg,msgbuf,str_nodll_title,MB_ICONSTOP | MB_TOPMOST );
		delete [] msgbuf;
		delete [] str_nodll_title;
		delete [] str_nodll_msg;
	}
	return 1; //err.
}
