/**
 * CommandoJikkyouSennyou - Commando Jikkyou Sennyou Client for twitter for Qt.
 *
 * Author: amayav (vamayav@yahoo.co.jp)
 *
 *
 *  CommandoJikkyouSennyou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  CommandoJikkyouSennyou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with CommandoJikkyouSennyou.  If not, see <http://www.gnu.org/licenses/>.
 */
#include "latesttweetsfortime.h"

LatestTweetsForTime::LatestTweetsForTime()
    : _postedDateTimeList()
{
}

const QList<QDateTime> LatestTweetsForTime::getPostedDateTimeList() const {
    return _postedDateTimeList;
}

bool LatestTweetsForTime::appendPostedDateTimeList(QDateTime &dataTime) {
    _postedDateTimeList.append(dataTime);
    return true;
}

bool LatestTweetsForTime::replacePostedDateTimeList(QDateTime &dataTime) {
    _postedDateTimeList.removeFirst();
    _postedDateTimeList.append(dataTime);
    return true;
}

bool LatestTweetsForTime::clear(){
    _postedDateTimeList.clear();
    return true;
}
