#ifndef OAUTH_H
#define OAUTH_H
#include <QtKOAuth>
#include <QNetworkReply>
#include <QObject>
#include <QSettings>
class KQOAuthManager;
class KQOAuthRequest;

class OAuth : public QObject
{
    Q_OBJECT

public:
    OAuth();
    ~OAuth();
    void showOAuthError(const int nErrNum);

    bool AuthorizationStarts();
    bool SendTweet(QString tweet);
    bool GetTimeLineStart();
    bool VerificationStarts(QString verificationNumber);
    QList<QString>* getUserTimeLine(int number);

public slots:
    void onTemporaryTokenReceived(QString token, QString tokenSecret);
    void onAuthorizationReceived(QString token, QString verifier);
    void onAccessTokenReceived(QString token, QString tokenSecret);
    void onAuthorizedRequestDone();
    void onRequestReady(QByteArray response);
    void onRequestReadyTimeline(QByteArray response);
    void onRequestReadyOwnPosts(QByteArray);

private:
    KQOAuthManager *_oauthManager;
    KQOAuthRequest *_oauthRequest;
    //  KQOAuthRequest_XAuth *oauthRequestX;
    QSettings *_oauthSettings,;

signals:
    void verificationReceived1(QString oauth_verifier);
};

#endif // OAUTH_H
