/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.advice;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jp.sourceforge.mergedoc.pleiades.aspect.Analyses;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.JointPoint;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.PleiadesConfigAssembler;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.PointCut;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.Files;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.xml.sax.helpers.DefaultHandler;

public class PleiadesConfig {
    private static final Logger log = Logger.getLogger(PleiadesConfig.class);
    private static final PleiadesConfig singleton = new PleiadesConfig();
    private PleiadesConfigAssembler pleiadesConfigAssembler = new PleiadesConfigAssembler();
    private Set<String> callNameSet = new HashSet<String>();
    private Set<String> callClassNameStartsSet = new HashSet<String>();
    private Set<String> callClassNameEndsSet = new HashSet<String>();

    public static PleiadesConfig getInstance() {
        return singleton;
    }

    private PleiadesConfig() {
        long start = System.nanoTime();
        File configFile = Files.getFile("pleiades-config.xml");
        try {
            if (!configFile.exists()) {
                throw new FileNotFoundException(configFile.getPath());
            }
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(configFile, (DefaultHandler)this.pleiadesConfigAssembler);
            Map<JointPoint, PointCut> jointMap = this.pleiadesConfigAssembler.getJointMap();
            for (JointPoint jointPoint : jointMap.keySet()) {
                if (jointPoint.getEditPoint() != JointPoint.EditPoint.CALL) continue;
                String className = jointPoint.getClassName();
                String methodName = jointPoint.getMethodName();
                this.callNameSet.add(String.valueOf(className) + "#" + methodName);
                if (methodName != null) continue;
                if (className.equals(className.toLowerCase())) {
                    this.callClassNameStartsSet.add(className);
                    continue;
                }
                if (className.contains(".")) continue;
                this.callClassNameEndsSet.add(className);
            }
            log.info("Pleiades \u69cb\u6210\u30d5\u30a1\u30a4\u30eb\u3092\u30ed\u30fc\u30c9\u3057\u307e\u3057\u305f\u3002", new Object[0]);
        }
        catch (Exception e) {
            String msg = "Pleiades \u69cb\u6210\u30d5\u30a1\u30a4\u30eb\u306e\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
            log.fatal(msg, new Object[0]);
            throw new IllegalStateException(msg, e);
        }
        Analyses.end(PleiadesConfig.class, "<init>", start);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsCall(String className, String methodName) {
        long start = System.nanoTime();
        try {
            if (this.callNameSet.contains(String.valueOf(className) + "#" + methodName)) {
                return true;
            }
            if (this.getSubstringMatch(className) == null) return false;
            return true;
        }
        finally {
            Analyses.end(PleiadesConfig.class, "containsCall", start);
        }
    }

    private String getSubstringMatch(String className) {
        long start = System.nanoTime();
        try {
            for (String starts : this.callClassNameStartsSet) {
                if (!className.startsWith(starts)) continue;
                String string = starts;
                return string;
            }
            for (String ends : this.callClassNameEndsSet) {
                if (!className.startsWith(ends)) continue;
                String string = ends;
                return string;
            }
            return null;
        }
        finally {
            Analyses.end(PleiadesConfig.class, "getSubstringMatch", start);
        }
    }

    public PointCut getPointCut(JointPoint jointPoint) {
        String classNameParts;
        Map<JointPoint, PointCut> jointMap = this.pleiadesConfigAssembler.getJointMap();
        PointCut pointCut = jointMap.get(jointPoint);
        if (pointCut != null) {
            return pointCut;
        }
        JointPoint key = new JointPoint(jointPoint);
        key.setDescriptor(null);
        pointCut = jointMap.get(key);
        if (pointCut != null) {
            return pointCut;
        }
        key.setMethodName(null);
        pointCut = jointMap.get(key);
        if (pointCut != null) {
            return pointCut;
        }
        if (key.getEditPoint() == JointPoint.EditPoint.CALL && (classNameParts = this.getSubstringMatch(key.getClassName())) != null) {
            key.setClassName(classNameParts);
            pointCut = jointMap.get(key);
            if (pointCut == null) {
                throw new IllegalStateException("\u30ed\u30b8\u30c3\u30af\u4e0d\u6b63\u3002\u30dd\u30a4\u30f3\u30c8\u30fb\u30ab\u30c3\u30c8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
            }
            return pointCut;
        }
        return null;
    }

    public String getProperty(String name) {
        return this.pleiadesConfigAssembler.getPropertyMap().get(name);
    }

    public String toString() {
        long start = System.nanoTime();
        Map<JointPoint, PointCut> jointMap = this.pleiadesConfigAssembler.getJointMap();
        try {
            String string = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append(jointMap).toString();
            return string;
        }
        finally {
            Analyses.end(PleiadesConfig.class, "toString", start);
        }
    }
}

