/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import jp.sourceforge.mergedoc.pleiades.aspect.advice.JointPoint;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.PleiadesConfig;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.DynamicTranslationDictionary;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

public class TraceableTranslationDictionary
extends DynamicTranslationDictionary {
    private static final Logger log = Logger.getLogger(TraceableTranslationDictionary.class);
    private final String traceWord;
    private final boolean traceIsJa;

    public TraceableTranslationDictionary() {
        PleiadesConfig config = PleiadesConfig.getInstance();
        this.traceWord = config.getProperty("trace.word");
        this.traceIsJa = Boolean.valueOf(config.getProperty("trace.is.ja"));
        log.warn("\u30c8\u30ec\u30fc\u30b9\u7ffb\u8a33\u8f9e\u66f8\u3092\u751f\u6210\u3057\u307e\u3057\u305f\u3002traceWord=%s, traceIsJa=%s", this.traceWord, this.traceIsJa);
    }

    protected String lookupInternal(String en, JointPoint jointPoint) {
        String target;
        String ja = super.lookupInternal(en, jointPoint);
        String string = target = this.traceIsJa ? ja : en;
        if (target.matches(this.traceWord)) {
            String s = String.valueOf(System.currentTimeMillis()) + "\u300c" + en + "\u300d\u2192\u300c" + ja + "\u300d";
            log.debug(new Exception(s), "\u30c7\u30d0\u30c3\u30b0\u7ffb\u8a33\u8ffd\u8de1\u30b9\u30bf\u30c3\u30af\u30c8\u30ec\u30fc\u30b9 jointPoint:" + jointPoint, new Object[0]);
            return s;
        }
        return ja;
    }
}

