/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import jp.sourceforge.mergedoc.pleiades.Pleiades;
import jp.sourceforge.mergedoc.pleiades.aspect.Analyses;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformedClassCache {
    private static final Logger log = Logger.getLogger(TransformedClassCache.class);
    private static final TransformedClassCache singleton = new TransformedClassCache();
    private final File cacheFile = Pleiades.getResourceFile("transformed-class.cache");
    private Map<String, byte[]> loadMap = new HashMap<String, byte[]>();
    private Map<String, byte[]> storeMap = new HashMap<String, byte[]>();

    public static TransformedClassCache getInstance() {
        return singleton;
    }

    private TransformedClassCache() {
        this.loadMap = this.load();
    }

    private Map<String, byte[]> load() {
        HashMap<String, byte[]> map;
        long start;
        block10: {
            start = System.nanoTime();
            map = new HashMap<String, byte[]>();
            if (Pleiades.getPleiadesOption().isClean()) {
                log.info("-clean \u306b\u3088\u308a " + this.cacheFile.getName() + " \u306f\u30ed\u30fc\u30c9\u3055\u308c\u307e\u305b\u3093\u3002", new Object[0]);
            } else if (!this.cacheFile.exists()) {
                log.info(String.valueOf(this.cacheFile.getName()) + "\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002", new Object[0]);
            } else {
                ZipInputStream in = null;
                try {
                    try {
                        in = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.cacheFile)));
                        ZipEntry inEntry = null;
                        while ((inEntry = in.getNextEntry()) != null) {
                            byte[] bytecode = IOUtils.toByteArray((InputStream)in);
                            map.put(inEntry.getName(), bytecode);
                        }
                        log.info("load   %6d \u30a8\u30f3\u30c8\u30ea\u30fc %s", map.size(), this.cacheFile.getName());
                    }
                    catch (Exception e) {
                        log.warn("\u5909\u63db\u6e08\u307f\u30af\u30e9\u30b9\u30fb\u30ad\u30e3\u30c3\u30b7\u30e5 %s \u306e\u7834\u640d\u3092\u691c\u51fa\u3002\u5fa9\u5143\u4e2d... - %s", this.cacheFile, e.toString());
                        this.cacheFile.delete();
                        map.clear();
                        IOUtils.closeQuietly((InputStream)in);
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
            }
        }
        Analyses.end(this.getClass(), "<init>", start);
        return map;
    }

    public void shutdown() {
        block7: {
            if (this.storeMap == null || this.storeMap.size() == 0) {
                return;
            }
            Map<String, byte[]> map = this.load();
            ZipOutputStream out = null;
            try {
                try {
                    out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.cacheFile)));
                    out.setLevel(1);
                    Map<String, byte[]> sMap = this.storeMap;
                    this.storeMap = null;
                    map.putAll(sMap);
                    for (Map.Entry<String, byte[]> entry : map.entrySet()) {
                        out.putNextEntry(new ZipEntry(entry.getKey()));
                        out.write(entry.getValue());
                    }
                    log.info("store  %6d \u30a8\u30f3\u30c8\u30ea\u30fc %s", map.size(), this.cacheFile.getName());
                }
                catch (IOException e) {
                    log.error(e, String.valueOf(this.cacheFile.getName()) + "\u306e\u4fdd\u7ba1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", new Object[0]);
                    IOUtils.closeQuietly((OutputStream)out);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    public void putNextLaunch(String className, byte[] bytecode) {
        if (this.storeMap == null) {
            return;
        }
        if (this.storeMap.containsKey(className)) {
            return;
        }
        this.storeMap.put(className, bytecode);
    }

    public byte[] get(String className) {
        return this.loadMap.remove(className);
    }
}

