/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.generator;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import jp.sourceforge.mergedoc.pleiades.generator.TranslationRule;
import jp.sourceforge.mergedoc.pleiades.generator.Validator;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.Files;
import jp.sourceforge.mergedoc.pleiades.resource.Property;
import jp.sourceforge.mergedoc.pleiades.resource.PropertySet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;

public class Generator {
    private static final Logger log = Logger.getLogger(Generator.class);
    private static final String REGEX_KEY_PREFIX = "%REGEX%";
    private static final String EXCLUDE_KEY_PREFIX = "%EXCLUDE%";
    private static boolean isClean;

    public static void main(String ... args) throws IOException {
        String argStr = ArrayUtils.toString((Object)args);
        log.info("\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3: " + argStr, new Object[0]);
        isClean = argStr.contains("-clean");
        new Generator().run();
    }

    private void run() throws IOException {
        File[] fileArray = Files.getFile("props").listFiles(Files.createSuffixFilter(".log"));
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File logFile = fileArray[n2];
            logFile.delete();
            ++n2;
        }
        PropertySet nlsUiCustomRuleProp = null;
        if (isClean || this.isModified("props/nls-ui-customized.properties", "props/temp-nls-ui-customized.properties")) {
            log.info("\u6821\u6b63\u6e08\u307f\u8a00\u8a9e\u30d1\u30c3\u30af\u8f9e\u66f8\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u3092\u30ed\u30fc\u30c9\u3057\u307e\u3059\u3002", new Object[0]);
            nlsUiCustomRuleProp = new PropertySet("props/nls-ui-customized.properties");
            log.info("\u6821\u6b63\u6e08\u307f\u8a00\u8a9e\u30d1\u30c3\u30af\u8f9e\u66f8\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u306b\u7ffb\u8a33\u30eb\u30fc\u30eb\u3092\u9069\u7528\u5206\u5272\u4e2d...", new Object[0]);
            nlsUiCustomRuleProp = new TranslationRule("props/nls-ui-customized.properties_rule.log", new PropertySet[0]).apply(nlsUiCustomRuleProp);
            nlsUiCustomRuleProp.store("props/temp-nls-ui-customized.properties", "\u6821\u6b63\uff06\u30eb\u30fc\u30eb\u9069\u7528\u6e08\u307f\u8a00\u8a9e\u30d1\u30c3\u30af\u30fb\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc (\u691c\u8a3c\u524d\u4e00\u6642\u30d5\u30a1\u30a4\u30eb)");
            log.info("\u6821\u6b63\u6e08\u307f\u8a00\u8a9e\u30d1\u30c3\u30af\u8f9e\u66f8\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u306e\u554f\u984c\u9664\u53bb\u4e2d (\u7ffb\u8a33\u30eb\u30fc\u30eb\u9069\u7528\u5206\u5272\u5f8c) ...", new Object[0]);
            Validator v = new Validator("props/nls-ui-customized.properties_validate.log", new PropertySet[0]);
            v.validate(nlsUiCustomRuleProp);
            this.exitIfValidationError(v);
            nlsUiCustomRuleProp.store("props/temp-nls-ui-customized.properties", "\u6821\u6b63\uff06\u30eb\u30fc\u30eb\u9069\u7528\u6e08\u307f\u8a00\u8a9e\u30d1\u30c3\u30af\u30fb\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc");
        } else {
            log.info("\u6821\u6b63\uff06\u30eb\u30fc\u30eb\u9069\u7528\u6e08\u307f\u8a00\u8a9e\u30d1\u30c3\u30af\u8f9e\u66f8\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u3092\u30ed\u30fc\u30c9\u3057\u307e\u3059\u3002", new Object[0]);
            nlsUiCustomRuleProp = new PropertySet("props/temp-nls-ui-customized.properties");
        }
        PropertySet outTransProp = new PropertySet();
        PropertySet outRegexProp = new PropertySet();
        PropertySet outExcludeProp = new PropertySet();
        Validator v = new Validator("props/temp-all.properties_validate.log", nlsUiCustomRuleProp);
        File[] dirs = Files.getFile("props/additions").listFiles(Files.createDirectoryFilter());
        Arrays.sort(dirs, new Comparator<File>(){

            @Override
            public int compare(File dir1, File dir2) {
                String dir1Name = dir1.getName();
                return dir1Name.equals("EPL") ? 1 : dir1Name.compareTo(dir2.getName());
            }
        });
        File[] fileArray2 = dirs;
        int n3 = dirs.length;
        int n4 = 0;
        while (n4 < n3) {
            File dir = fileArray2[n4];
            String license = dir.getName();
            if (!license.startsWith(".")) {
                Object propFile;
                File regexPropFile = Files.getFile("props/additions/regex-" + license + ".properties");
                File excludePropFile = Files.getFile("props/additions/exclude-" + license + ".properties");
                File transPropFile = Files.getFile("props/translation-" + license + ".properties");
                PropertySet regexProp = new PropertySet();
                PropertySet excludeProp = new PropertySet();
                PropertySet transProp = new PropertySet();
                Object[] propFiles = dir.listFiles(Files.createSuffixFilter(".properties"));
                boolean updated = false;
                Object[] objectArray = propFiles;
                int n5 = propFiles.length;
                int n6 = 0;
                while (n6 < n5) {
                    propFile = objectArray[n6];
                    if (((File)propFile).lastModified() > transPropFile.lastModified()) {
                        updated = true;
                    }
                    ++n6;
                }
                if (updated || isClean) {
                    Arrays.sort(propFiles);
                    objectArray = propFiles;
                    n5 = propFiles.length;
                    n6 = 0;
                    while (n6 < n5) {
                        propFile = objectArray[n6];
                        PropertySet addProp = new PropertySet(new File[]{propFile});
                        log.debug("Loaded " + ((File)propFile).getName() + " " + addProp.size(), new Object[0]);
                        for (Property p : addProp) {
                            String newKey;
                            if (p.key.startsWith(REGEX_KEY_PREFIX)) {
                                newKey = p.key.replaceFirst("^%REGEX%", "").trim();
                                String newVal = p.value.trim();
                                regexProp.put(newKey, newVal);
                                continue;
                            }
                            if (p.key.startsWith(EXCLUDE_KEY_PREFIX)) {
                                newKey = p.key.replaceFirst("^%EXCLUDE%", "").trim();
                                Object existsValue = outExcludeProp.get(newKey);
                                if (existsValue != null) {
                                    p.value = existsValue + "," + p.value;
                                }
                                excludeProp.put(newKey, p.value);
                                continue;
                            }
                            v.validate(p, ((File)propFile).getName());
                            transProp.put(p);
                        }
                        ++n6;
                    }
                    v.logEndMessage("\u30e9\u30a4\u30bb\u30f3\u30b9\u5225\u7ffb\u8a33\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc (" + license + ") \u691c\u8a3c\u7d50\u679c");
                    this.exitIfValidationError(v);
                    log.info("\u30e9\u30a4\u30bb\u30f3\u30b9\u5225\u7ffb\u8a33\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc (" + license + ") \u306b\u7ffb\u8a33\u30eb\u30fc\u30eb\u3092\u9069\u7528\u5206\u5272\u4e2d...", new Object[0]);
                    transProp = new TranslationRule("props/temp-all.properties_rule.log", nlsUiCustomRuleProp).apply(transProp);
                    log.info("\u30e9\u30a4\u30bb\u30f3\u30b9\u5225\u7ffb\u8a33\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc (" + license + ") \u306e\u554f\u984c\u9664\u53bb\u4e2d (\u7ffb\u8a33\u30eb\u30fc\u30eb\u9069\u7528\u5206\u5272\u5f8c) ...", new Object[0]);
                    v = new Validator("props/temp-all.properties_validate.log", nlsUiCustomRuleProp);
                    transProp = v.remove(transProp);
                    this.exitIfValidationError(v);
                    if (license.equals("EPL")) {
                        transProp = this.mergeEPL(transProp, nlsUiCustomRuleProp);
                    }
                    transProp.store(transPropFile, "\u30e9\u30a4\u30bb\u30f3\u30b9\u5225\u7ffb\u8a33\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc (" + license + ")");
                    regexProp.store(regexPropFile, "\u30e9\u30a4\u30bb\u30f3\u30b9\u5225\u6b63\u898f\u8868\u73fe\u7ffb\u8a33\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc (" + license + ")");
                    excludeProp.store(excludePropFile, "\u30e9\u30a4\u30bb\u30f3\u30b9\u5225\u7ffb\u8a33\u9664\u5916\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc (" + license + ")");
                } else {
                    transProp.load(transPropFile);
                    regexProp.load(regexPropFile);
                    excludeProp.load(excludePropFile);
                }
                outTransProp.putAll(transProp);
                outRegexProp.putAll(regexProp);
                outExcludeProp.putAll(excludeProp);
            }
            ++n4;
        }
        PropertySet outMultibyteProp = new PropertySet();
        for (Property p : outTransProp) {
            if (p.key.length() == p.key.getBytes().length) continue;
            outMultibyteProp.put(p);
        }
        for (Property p : outMultibyteProp) {
            outTransProp.remove(p.key);
        }
        Generator.storeHistory(outTransProp, "props/temp-all.properties", "\u8f9e\u66f8\u5168\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\uff08\u751f\u6210\u78ba\u8a8d\u7528\u30c6\u30f3\u30dd\u30e9\u30ea\u30fc\uff09");
        outTransProp.store("translation.properties", "\u7ffb\u8a33\u8f9e\u66f8\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\n\n  \u30e9\u30a4\u30bb\u30f3\u30b9\u5225\u7ffb\u8a33\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u3092\u30de\u30fc\u30b8\u3057\u305f\u3082\u306e\u3067\u3001\n  Pleiades \u304c\u5b9f\u884c\u6642\u306b\u53c2\u7167\u3057\u307e\u3059\u3002\n  \n  \u5165\u529b\u5143\u30d5\u30a1\u30a4\u30eb\uff1aprops/translation-*.properties\n  \n  \u53e5\u70b9\u89e3\u6790\u306b\u3088\u308a\u30a8\u30f3\u30c8\u30ea\u30fc\u306f\u53ef\u80fd\u306a\u9650\u308a\u6587\u5358\u4f4d\u306b\u5206\u5272\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u307e\u305f\u3001\n  \u91cd\u8907\u9632\u6b62\u3084\u30ea\u30bd\u30fc\u30b9\u3001\u30e1\u30e2\u30ea\u30fc\u6d88\u8cbb\u91cf\u4f4e\u6e1b\u306e\u305f\u3081\u3001\u6b21\u306e\u3088\u3046\u306a\u6587\u5b57\u306f\n  \u9664\u53bb\u3055\u308c\u3066\u304a\u308a\u3001\u7ffb\u8a33\u6642\u306f\u539f\u6587\u3092\u5143\u306b\u81ea\u52d5\u7684\u306b\u88dc\u5b8c\u3055\u308c\u307e\u3059\u3002\n  \n  \u30fb\u30cb\u30fc\u30e2\u30cb\u30c3\u30af\uff1a\u82f1\u8a9e\u306e\u5834\u5408\u306f & 1 \u6587\u5b57\u3001\u65e5\u672c\u8a9e\u306e\u5834\u5408\u306f (&x) 4 \u6587\u5b57\n  \u30fb\u5148\u982d\u30fb\u672b\u5c3e\u306e\u9023\u7d9a\u3059\u308b\u7a7a\u767d\uff1a\\r\u3001\\n\u3001\\t\u3001\u534a\u89d2\u30b9\u30da\u30fc\u30b9\n  \u30fb\u524d\u5f8c\u306e\u56f2\u307f\u6587\u5b57 ()\u3001[]\u3001<>\u3001\"\"\u3001''\u3001!! \u306a\u3069 (\u524d\u5f8c\u306e\u7d44\u307f\u5408\u308f\u305b\u304c\u4e00\u81f4\u3059\u308b\u5834\u5408)\n  \u30fb\u5148\u982d\u306e IWAB0001E \u306e\u3088\u3046\u306a Eclipse \u56fa\u6709\u30e1\u30c3\u30bb\u30fc\u30b8\u30fb\u30b3\u30fc\u30c9\n  \u30fb\u8907\u6570\u5f62\u3092\u793a\u3059 (s) (\u79d2\u3092\u793a\u3059\u3082\u306e\u3067\u306f\u306a\u3044\u5834\u5408)");
        outRegexProp.store("translation-regex.properties", "\u6b63\u898f\u8868\u73fe\u8f9e\u66f8\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\n\n  \u6b63\u898f\u8868\u73fe\u3067\u7ffb\u8a33\u3059\u308b\u305f\u3081\u306e\u8f9e\u66f8\u3067\u3001Pleiades \u304c\u5b9f\u884c\u6642\u306b\u53c2\u7167\u3057\u307e\u3059\u3002\n  \u5165\u529b\u5143\u30d5\u30a1\u30a4\u30eb\uff1aprops/additions/*.properties \u306e\u30ad\u30fc\u5148\u982d\u306b %REGEX% \u304c\u3042\u308b\u9805\u76ee");
        outExcludeProp.store("translation-exclude-package.properties", "\u7ffb\u8a33\u9664\u5916\u30d1\u30c3\u30b1\u30fc\u30b8\u30fb\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\n\n  \u7ffb\u8a33\u3092 Java \u30d1\u30c3\u30b1\u30fc\u30b8\u5358\u4f4d\u3067\u9664\u5916\u8a33\u3059\u308b\u305f\u3081\u306e\u8f9e\u66f8\u3067\u3001Pleiades \u304c\u5b9f\u884c\u6642\u306b\u53c2\u7167\u3057\u307e\u3059\u3002\n  \u5165\u529b\u5143\u30d5\u30a1\u30a4\u30eb\uff1aprops/additions/*.properties \u306e\u30ad\u30fc\u5148\u982d\u306b %EXCLUDE% \u304c\u3042\u308b\u9805\u76ee");
        outMultibyteProp.store("translation-multibytes-key.properties", "\u7ffb\u8a33\u30de\u30eb\u30c1\u30fb\u30d0\u30a4\u30c8\u30fb\u30ad\u30fc\u30fb\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\n\n  \u7ffb\u8a33\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u304b\u3089\u30ad\u30fc\u306b\u30de\u30eb\u30c1\u30fb\u30d0\u30a4\u30c8\u304c\u542b\u307e\u308c\u308b\u3082\u306e\u3092\u62bd\u51fa\u3057\u305f\u8f9e\u66f8\u3067\u3001\n  Pleiades \u304c\u5b9f\u884c\u6642\u306b\u53c2\u7167\u3057\u307e\u3059\u3002\n  \u30c7\u30d5\u30a9\u30eb\u30c8\u306e\u7ffb\u8a33\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u30fb\u30ed\u30fc\u30c9\u6291\u6b62\u5224\u5b9a\u306e\u305f\u3081\u306b\u4f7f\u7528\u3055\u308c\u307e\u3059\u3002");
        if (isClean || this.isModified("props/temp-nls-help-unchecked.properties", "translation-help-unchecked.properties")) {
            PropertySet outHelpUncheckedProp = new PropertySet("props/temp-nls-help-unchecked.properties");
            outHelpUncheckedProp.store("translation-help-unchecked.properties", "\u30d8\u30eb\u30d7\u8f9e\u66f8\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc (\u691c\u8a3c\u30a8\u30e9\u30fc\u306e\u3082\u306e)\n\n  \u8a00\u8a9e\u30d1\u30c3\u30af\u306e\u30d8\u30eb\u30d7\u304b\u3089\u62bd\u51fa\u3057\u305f\u3082\u306e\u3067\u3059\u3002\n  \u5165\u529b\u5143\u30d5\u30a1\u30a4\u30eb\uff1aprops/temp-nls-help-unchecked.properties");
        }
    }

    private PropertySet mergeEPL(PropertySet eplProp, PropertySet nlsUiCustomRuleProp) {
        PropertySet mergedProp = new PropertySet();
        mergedProp.load("props/temp-nls-help-checked.properties");
        mergedProp.putAll(eplProp);
        mergedProp.putAll(nlsUiCustomRuleProp);
        PropertySet noSplitProp = new PropertySet();
        noSplitProp.putAll(new TranslationRule(new PropertySet[0]).apply(noSplitProp));
        noSplitProp.load("props/no-split.properties");
        Validator v = new Validator("props/no-split.properties_validate.log", mergedProp);
        v.validate(noSplitProp);
        this.exitIfValidationError(v);
        mergedProp.putAll(noSplitProp);
        return mergedProp;
    }

    private boolean isModified(String src, String dst) {
        return Files.getFile(src).lastModified() > Files.getFile(dst).lastModified();
    }

    private void exitIfValidationError(Validator validator) {
        if (!validator.isSuccess()) {
            log.error("\u691c\u8a3c\u30a8\u30e9\u30fc\u306e\u305f\u3081\u3001\u5f37\u5236\u7d42\u4e86\u3057\u307e\u3059\u3002", new Object[0]);
            System.exit(-1);
        }
    }

    public static void storeHistory(PropertySet prop, String path, String comment) throws IOException {
        List<String> keyList = prop.store(path, comment);
        if (keyList == null) {
            return;
        }
        File textFile = Files.getFile(Files.toVcIgnoreName(String.valueOf(path) + ".txt"));
        if (textFile.exists()) {
            File textOldFile = Files.getFile(Files.toVcIgnoreName(String.valueOf(path) + "_old.txt"));
            textOldFile.delete();
            textFile.renameTo(textOldFile);
        }
        LinkedList<String> lines = new LinkedList<String>();
        lines.add("#" + prop.size() + " \u30a8\u30f3\u30c8\u30ea\u30fc");
        for (String key : keyList) {
            String line = Property.toString(key, (String)prop.get(key));
            lines.add(line);
        }
        FileUtils.writeLines((File)textFile, (String)"UTF-8", lines);
    }
}

