# Finds the Microsoft DirectX9
#
#  [out]DIRECTX_FOUND          - True if DirectX found.
#  [out]DIRECTX_INCLUDE_DIR    - Directory to include to get DirectX headers
#  [out]DIRECTX_LIBRARY_DIRS   - Directory to Library to get DirectX library
#  [out]DIRECTX_LIBRARIES      - Libraries to link against for the DirectX library
#  [in]DIRECTX_ROOT            - root dir of Direct 3D

# link libraries
set(DIRECTX_FIND_COMPONENTS d3d9;d3dx9;d3dx9d;dsound;dinput8)

# If DIRECTX_ROOT was defined in the environment, use it.
if (NOT DIRECTX_ROOT AND NOT $ENV{DIRECTX_ROOT} STREQUAL "")
        set(DIRECTX_ROOT $ENV{DIRECTX_ROOT})
endif ()

if (DIRECTX_ROOT) 
        SET(
                _directx_INCLUDE_SEARCH_DIRS
                ${DIRECTX_ROOT}/Include
                ${DIRECTX_ROOT}
        )
        SET(
                _directx_LIBRARIES_SEARCH_DIRS
                ${DIRECTX_ROOT}/Lib/x86
                ${DIRECTX_ROOT}
        )
endif () 

# Look for the header file.
find_path(
  DIRECTX_INCLUDE_DIR 
  NAMES d3dx9.h 
  DOC "Include directory for the DirectX9 library"
  HINTS ${_directx_INCLUDE_SEARCH_DIRS}
)
mark_as_advanced(DIRECTX_INCLUDE_DIR)

# Look for the library.
foreach (COMPONENT ${DIRECTX_FIND_COMPONENTS})
        find_library(
                _directx_FOUND_LIBRARY_${COMPONENT}
                NAMES ${COMPONENT}
                DOC "Libraries for the DirectX Library"
                HINTS ${_directx_LIBRARIES_SEARCH_DIRS}
        )
        set(DIRECTX_LIBRARIES ${DIRECTX_LIBRARIES} ${_directx_FOUND_LIBRARY_${COMPONENT}})
        GET_FILENAME_COMPONENT(_directx_PATH_${COMPONENT} ${_directx_FOUND_LIBRARY_${COMPONENT}} PATH )
        list(APPEND DIRECTX_LIBRARY_DIRS ${_directx_PATH_${COMPONENT}})
endforeach ()
list(REMOVE_DUPLICATES DIRECTX_LIBRARY_DIRS)
mark_as_advanced(DIRECTX_LIBRARIES)
mark_as_advanced(DIRECTX_LIBRARY_DIRS)

# set DIRECTX_FOUND
if (DIRECTX_INCLUDE_DIR AND DIRECTX_LIBRARY_DIRS)
  set(DIRECTX_FOUND 1)
else ()
  set(DIRECTX_FOUND 0)
endif ()
