#   依存外部ライブラリの設宁E
# 
# - 新たな依存ライブラリを追加するにはEE
# 	標準でfind_packageできるもEとEE刁EFindXXX.cmakeファイルを用意しなければならなぁEのがある．標準で備わってぁEかどぁEはEE
#
# 	http://www.cmake.org/cmake/help/cmake-2-8-docs.html
#
# 	を参照すればわかる！E
#

# use Boost Library
find_package(Boost COMPONENTS filesystem thread)
if (Boost_FOUND)
	message(STATUS "Found the Boost Library:")
	message(STATUS "	include directories=${Boost_INCLUDE_DIR}")
	message(STATUS "	library directories=${Boost_LIBRARY_DIRS}")
	include_directories(${Boost_INCLUDE_DIR})
else ()
	message(FATAL_ERROR "Could not find Boost Library.")
endif ()

# use DirectX
find_package(DirectX)
if (DIRECTX_FOUND)
	message(STATUS "Found the DirectX:")
	message(STATUS "	include directories=${DIRECTX_INCLUDE_DIR}")
	message(STATUS "	library directories=${DIRECTX_LIBRARY_DIRS}")
	include_directories(${DIRECTX_INCLUDE_DIR})
	link_directories(${DIRECTX_LIBRARY_DIRS})
else ()
	message(FATAL_ERROR "Could not find DirectX.")
endif ()


# extlibs
include_directories(${MOFLIB_ROOT_DIR}/../extlib/expat/include)
include_directories(${MOFLIB_ROOT_DIR}/../extlib/libogg-1.2.0/include)
include_directories(${MOFLIB_ROOT_DIR}/../extlib/libvorbis-1.3.1/include)
include_directories(${MOFLIB_ROOT_DIR}/../extlib/lua5.1/include)
include_directories(${MOFLIB_ROOT_DIR}/../extlib/luabind-0.8/)
