#include "mof/DirectionalLight.hpp"
#include <d3dx9.h>
#include "mof/GraphicsDevice.hpp"
#include "mof/private/GraphicsDeviceImpl.hpp"


mof::DirectionalLight::DirectionalLight(mof::Color diffuse , mof::Color ambient , mof::Vector3D& direction)
: mof::Light()
{
	setDiffuseColor(diffuse);
	setAmbientColor(ambient);
	setDirection(direction);

}


void mof::DirectionalLight::update(){
	//mof::Animation* pAnimation = getAnimation();
	//if(pAnimation == NULL)return;
	//pAnimation->update();
	//mof::Color color = pAnimation->get();
	//set(pAnimation->getColor());
}

void mof::DirectionalLight::reflect(){
	LPDIRECT3DDEVICE9 pDevice = mof::GraphicsDevice::getRawDevice();
	D3DLIGHT9 light;
	ZeroMemory(&light , sizeof(light));
	light.Type = D3DLIGHT_DIRECTIONAL;
	light.Diffuse.a = (float)mof::getAlpha(m_diffuse) / 255.0f;
	light.Diffuse.r = (float)mof::getRed(m_diffuse) / 255.0f;
	light.Diffuse.g = (float)mof::getGreen(m_diffuse) / 255.0f;
	light.Diffuse.b = (float)mof::getBlue(m_diffuse) / 255.0f;

	light.Ambient.a = (float)mof::getAlpha(m_ambient) / 255.0f;
	light.Ambient.r = (float)mof::getRed(m_ambient) / 255.0f;
	light.Ambient.g = (float)mof::getGreen(m_ambient) / 255.0f;
	light.Ambient.b = (float)mof::getBlue(m_ambient) / 255.0f;

	light.Direction = D3DXVECTOR3(m_direction.x , m_direction.y , m_direction.z);
	
	
	pDevice->SetLight(0 , &light);
	pDevice->LightEnable(0 , TRUE);
}
