#pragma once
#include "mof/Light.hpp"
#include "mof/Color.hpp"
#include "mof/Vector3D.hpp"

namespace mof{

	class DirectionalLight : public Light{
		mof::Color m_diffuse;
		mof::Color m_ambient;
		mof::Vector3D m_direction;
	public:
		DirectionalLight(mof::Color diffuse , mof::Color ambient , mof::Vector3D& direction);
		void setDiffuseColor(mof::Color diffuse){m_diffuse = diffuse;}
		void setAmbientColor(mof::Color ambient){m_ambient = ambient;}
		void setDirection(mof::Vector3D& direction){m_direction = direction;}

		virtual void update();
		virtual void reflect();

	};

};
