#ifndef MOF_EVENT_SCHEDULER_HPP
#define MOF_EVENT_SCHEDULER_HPP
#include <boost/scoped_ptr.hpp>
#include <boost/function/function0.hpp>
#include "mof/stream/Manipulator.hpp"

namespace mof{

class EventCondition;

class EventScheduler{
	struct Impl;
	boost::scoped_ptr<Impl> m_pImpl;

public:
	typedef boost::function0<void> Action;
	EventScheduler();
	~EventScheduler();

	void addEvent(mof::EventCondition* pCondition , const Action& action);
	void addEvent(mof::FrameNumber interval , const Action& action);
	void update();
	void clear();
};

}




#endif
