#include "mof/FilePath.hpp"
#include <boost/regex.hpp>
#include "mof/ConsoleIO.hpp"


mof::FilePath::FilePath(const mof::tstring& path){
	m_path = path;
}


mof::tstring mof::FilePath::getFormat(){
	try {
		boost::regex regex("(.*)\\.(.*)");//name . format
		boost::smatch match;
		//ɂ͑ΉĂȂ
		if(!boost::regex_search(m_path , match , regex)){
			DEBUG_PRINT(_T("FormatError --- ") << m_path);
			return mof::tstring();
		}
		return match.str(2);	
	}
	catch (std::exception &e) {
		throw e;
	}
	return mof::tstring();
}
		

mof::tstring& mof::FilePath::getPath(){
	return m_path;
}

mof::tstring mof::FilePath::dir(){
	try {
		boost::regex regex("(.*)/[^/]*\\.(.*)");//name . format
		boost::smatch match;
		//ɂ͑ΉĂȂ
		if(!boost::regex_search(m_path , match , regex)){
			DEBUG_PRINT(_T("FormatError --- ") << m_path);
			return mof::tstring();
		}
		return match.str(1);	
	}
	catch (std::exception &e) {
		throw e;
	}
	return mof::tstring();

}
		
mof::tstring mof::FilePath::basename(){
	try {
		boost::regex regex("(.*)/([^/]*)");//name . format
		boost::smatch match;
		//ɂ͑ΉĂȂ
		if(!boost::regex_search(m_path , match , regex)){
			DEBUG_PRINT(_T("FormatError --- ") << m_path);
			return mof::tstring();
		}
		return match.str(2);	
	}
	catch (std::exception &e) {
		throw e;
	}
	return mof::tstring();

}

