#include "mof/private/Mesh.hpp"
#include "mof/GraphicsDevice.hpp"
#include "mof/private/MeshDisposer.hpp"
#include "mof/stream/Constant.hpp"
#include "mof/ConsoleIO.hpp"

struct mof::Mesh::Impl{
	
	std::shared_ptr<mof::MeshDisposer> pMeshDisposer;
	unsigned long nMaterials;
	std::shared_ptr<Material>* materials; 
	std::shared_ptr<Texture>* textures;
	mof::Manipulator<mof::Matrix3D>::Handler worldMatrix;
	mof::FrameNumber m_frame;
	

	Impl(
		std::shared_ptr<mof::MeshDisposer> pMeshDisposer_ ,
		unsigned long nMaterials_ 
		) : 
		pMeshDisposer(pMeshDisposer_) , 
		nMaterials(nMaterials_) , materials(NULL) , textures(NULL) ,
		worldMatrix(mof::makeConstantHandler(mof::Matrix3D::createIdentity()))
		{}

	~Impl(){
		delete[] materials;
		delete[] textures;
		}
}; 

mof::Mesh::Mesh(
	std::shared_ptr<mof::MeshDisposer> pMeshDisposer ,
	unsigned long nMaterials ,
	const std::shared_ptr<Material>* materials , 
	const std::shared_ptr<Texture>* textures 
	) : m_pImpl(new Impl(pMeshDisposer , nMaterials )){

	m_pImpl->materials = new std::shared_ptr<mof::Material>[nMaterials];
	m_pImpl->textures = new std::shared_ptr<mof::Texture>[nMaterials];	

	for(unsigned long i = 0 ; i < nMaterials ; i++ ){
		m_pImpl->materials[i] = materials[i];
		m_pImpl->textures[i] = textures[i];
	}
}

mof::Mesh::~Mesh(){
}
	


void mof::Mesh::setWorldMatrix(const mof::Manipulator<mof::Matrix3D>::Handler& handler){
	m_pImpl->worldMatrix = handler;
}





void mof::Mesh::setTexture( 
		unsigned int num ,
		const std::shared_ptr<mof::Texture>& pTexture){

	if(num < m_pImpl->nMaterials)m_pImpl->textures[num] = pTexture;	

}


bool mof::Mesh::isVisible() const{
	return true;
}


void mof::Mesh::update(){
	m_pImpl->m_frame++;
}

void mof::Mesh::draw() const{
	

	for( DWORD i = 0;  i < m_pImpl->nMaterials ; i++ )
	{
      	mof::GraphicsDevice::setMaterial(*m_pImpl->materials[i].get());	
		mof::GraphicsDevice::setTexture(m_pImpl->textures[i].get());
		mof::GraphicsDevice::setWorldTransform(m_pImpl->worldMatrix->value(m_pImpl->m_frame));

		HRESULT hr = m_pImpl->pMeshDisposer->pMesh->DrawSubset( i );
		if(FAILED(hr))throw std::runtime_error("Failed --- DrawSubset");
	}
}

