#pragma once
#include <mof/script/LuaInterpreter.hpp>
#include <mof/script/lua_state.hpp>
#include <lua.hpp>
#include "luabind/luabind.hpp"
#include <mof/ConsoleIO.hpp>
#include <mof/utilities.hpp>
#include <boost/bind.hpp>
#include <list>

namespace mof
{
namespace script
{
//{{{ Impl
	struct LuaInterpreter::Impl
	{
		std::vector<lua_State*> threads_;
		
		Impl()
		{
		}

		~Impl()
		{
		}

	};
//}}}
//{{{ constructor
	LuaInterpreter::LuaInterpreter(const mof::tstring& filename)
	: impl_(new Impl())
	{
		
		int error = luaL_dofile(lua_state::instance().raw_lua(), filename.c_str());
		if(error)
		{
			throw std::runtime_error(lua_tostring(lua_state::instance().raw_lua(), -1));
		}
			

	}
//}}}
//{{{ destructor
	LuaInterpreter::~LuaInterpreter()
	{
	}
//}}}
//{{{ update
	void LuaInterpreter::update()
	{
		foreach (auto& co, impl_->threads_) {
			if (!co) continue;// スレッドは既に終了している

			int error = lua_resume(co, 0);
			if (!error) co = NULL;
			else if (error != LUA_YIELD) throw std::logic_error(std::string("lua error:") + lua_tostring(co, -1));
		}
	}
//}}}
//{{{ start
	void LuaInterpreter::start(const mof::tstring& entry_function)
	{
		lua_State* co = lua_newthread(lua_state::instance().raw_lua());
		if(!co)
		{
			DEBUG_PRINT(_T("ERROR-Failed lua_newthread") );
			throw std::runtime_error("Failed --- start lua script");
		}
		lua_getglobal(co, entry_function.c_str());
		impl_->threads_.push_back(co);

	}
//}}}
//{{{ bind
	void LuaInterpreter::bind(std::shared_ptr<CommandSet> commands)
	{
		lua_state::instance().bind(commands);
	}
//}}}

}// namespace script
}// namespace mof
